#!/usr/bin/env python
# -*- coding: latin-1 -*-

#Programa de demostracin de PythonG
#-----------------------------------

from modulepythong import *
from math import pi
import time,sys

window_style('Atraccin gravitatoria','black','G')
#set_window_update_mode(1)

class Planeta:
  def __init__(self,x,y,vx,vy,masa,color):
    self.x,self.y,self.vx,self.vy,self.masa,self.color=x,y,vx,vy,masa,color
  def dibuja(self):
    return create_circle(self.x, self.y, self.masa, self.color)

def gravedad(p1,lp):
  for p2 in lp:
    x21=p2.x-p1.x
    y21=p2.y-p1.y
    x12=p1.x-p2.x
    y12=p1.y-p2.y
    r3=(x21*x21 + y21*y21) ** 1.5
    masa1r3=p1.masa/r3
    masa2r3=p2.masa/r3
    p1.vx+=masa2r3*(x21)
    p1.vy+=masa2r3*(y21)
    p2.vx+=masa1r3*(x12)
    p2.vy+=masa1r3*(y12)
  p1.x += p1.vx
  p1.y += p1.vy
  
#Programa principal  
t=400
window_coordinates(-t,-t,t,t)

#Si quieres aadir mas planetas, adelante...
lp=[]
lp.append(Planeta(-200.0,-200.0,0.1,0.0,20.0,'red'))
lp.append(Planeta(200.0,200.0,-0.1,0.0,20.0,'magenta'))
lp.append(Planeta(0.0,0.0,0.1,0.1,0.01,'green'))

lc=[]
for p in lp: lc.append(p.dibuja())

tecla=None
t1=time.time()
#while tecla!='Escape':
for rr in range(1500):
  window_update()
  tecla=keypressed(0)
  old_x=[]
  old_y=[]
  for p in lp:
    old_x.append(p.x)
    old_y.append(p.y)
  for r in range(10):
    for i in range(len(lp)):
      gravedad(lp[i],lp[i+1:]) 
  old_lc=lc[:]
  lc=[]
  for i in range(len(lp)):
    lc.append(lp[i].dibuja())
    erase(old_lc[i])
    create_line(old_x[i],old_y[i],lp[i].x,lp[i].y,lp[i].color)
t2=time.time()
sys.stderr.write('Tiempo de ejecucin: %f segundos\n' % (t2-t1))
create_text(0,-400,"Pulsa <Return> para salir:",10,'S','white')
raw_input()
