#!/usr/bin/env python
# -*- coding: latin-1 -*-

#Programa de demostracin de PythonG
#-----------------------------------

from modulepythong import *
from math import sin,cos,pi,sqrt
import time

window_style("Spyro",'white','G')

#Cambiando estos valores se obtiene dibujos diferentes
radioCirculo = 200
radioDisco = 75
distLapizCentroDisco = 50

velocidad = 0.04    #reducir para aumentar velocidad
dientesCirculo = 40 # no es necesario cambiar este valor

def rueda(x0, y0, radio, numDientes, profDiente, ini):
  r1 = radio-profDiente/2.0
  r2 = radio+profDiente/2.0
  l=[]
  da = 2.0*pi/numDientes/4.0
  cte = 2.0*pi/numDientes
  ini = ini-da*3/2 
  for i in range(0,numDientes):
    angle = i*cte+ini
    l.append((r1*cos(angle)+x0, r1*sin(angle)+y0))
    l.append((r2*cos(angle+da)+x0, r2*sin(angle+da)+y0))
    l.append((r2*cos(angle+2*da)+x0, r2*sin(angle+2*da)+y0))
    l.append((r1*cos(angle+3*da)+x0, r1*sin(angle+3*da)+y0))
  return l+[l[0]]

def mcm(i,j):
  while 1:
    r=i%j
    if r==0: return j
    i,j=j,r

def spyro(a,b,rd,di):
  profD=10 # profundidad diente
  create_filled_circle(0,0,3,'red')
  xx2, yy2 = a-b, 0
  print "Tamao diente: %g" % (float(a)/di)
  print "N dientes agujero:",di
  l=rueda(0, 0, a-profD/2, di, profD, 0)
  dibuja_rueda(l,'red')
  n2=int(di*float(b)/a)
  print "N dientes disco:",n2
  b2=n2*float(a)/di
  if b2!=b:
    print "Ajustado radio del disco: %g -> %g" % (b,b2)
    b=b2
    
  rab=(a-b)
  l=rueda(rab, 0, b-profD/2, n2, profD, 0)
  r2=dibuja_rueda(l,'blue')
  create_filled_circle(rab,0,3,'blue',tags='disco')
  create_filled_circle(rab+rd,0,3,'black',tags='lapiz')
  theta=0.0
  thetad=pi*0.02#12#52
  aoverb=float(di)/n2
  N = n2/mcm(di,n2)
  print "Vueltas:",N
  x2, y2 = rab+rd, 0.0
  ang=0
  inc=-((di-n2)*(2*pi/n2))/100
  l=create_line(x2,y2,xx2,yy2,'blue')
  for i in range(1,100*N+1):
    #if i=100*N: raise "kkk"
    ang+=1
    theta+=thetad
    phi=theta*aoverb
    phi=-ang*inc
    #print phi,ang*inc
    #keypressed()
    xx, yy = rab*cos(theta), rab*sin(theta)
    x, y   = xx+rd*cos(phi), yy-rd*sin(phi)
    create_line(x,y,x2,y2)
    move('lapiz',x-x2,y-y2)
    c=rueda(xx, yy, b-profD/2, n2, profD, -phi)
    r=dibuja_rueda(c,'blue')
    map(erase,r2)
    r2=r
    move('disco',xx-xx2,yy-yy2)
    erase(l)
    l=create_line(x, y, xx, yy, 'blue')
    x2, y2   = x, y
    xx2, yy2 = xx, yy
    time.sleep(velocidad)

def dibuja_rueda(l,color):
  r=[]
  x2,y2=l[0]
  for x,y in l[1:]:
    r.append(create_line(x,y,x2,y2,color))
    x2,y2=x,y
  return r

window_coordinates(-250,-250,250,250)
spyro(radioCirculo,radioDisco,distLapizCentroDisco,dientesCirculo)
create_text(0,-250,"Pulsa <Return> para salir:", 10, 'S')
raw_input()
