# -*- coding: iso-8859-1 -*-
# 'modulepythong.py' debe utilizarse como mdulo en los programas 
# desarrollados en el entorno PythonG, para que puedan
# ejecutarse fuera de dicho entorno. Basta aadir al cdigo
# la lnea:
#   from modulepythong import *
# Notas:
# 1. Al finalizar la ejecucin del programa hay que cerrar
#    la ventana grfica.
# 2. La salida de error est en el terminal desde el que se
#    lanza el programa.
#
# Copyright (C) 2003 Universitat Jaume I (Castello, Spain)
#
# LICENCIA:
# Este programa es Software Libre; usted puede redistribuirlo
# y/o modificarlo bajo los trminos de la "GNU General Public
# License" como lo publica la "FSF Free Software Foundation",
# o (a su eleccin) de cualquier versin posterior.
#
# Este programa es distribuido con la esperanza de que le ser
# til, pero SIN NINGUNA GARANTIA; incluso sin la garanta
# implcita por el MERCADEO o EJERCICIO DE ALGUN PROPOSITO en
# particular. Vea la "GNU General Public License" para ms
# detalles.
#
# Usted debe haber recibido una copia de la "GNU General Public
# License" junto con este programa, si no, escriba a la "FSF
# Free Software Foundation, Inc.", 59 Temple Place - Suite 330,
# Boston, MA  02111-1307, USA.
#
#----------------------------------------------------------------
#
# AUTOR: David Llorens (dllorens@lsi.uji.es)
#        Dpto. de Lenguajes y Sistemas Informticos
#        Universitat Jaume I
#        Castell (Spain)
# LICENCIA: GPL versin 2
# FECHA: 3-Diciembre-2003
#
# CHANGELOG:
#  2-12-03 Versin 0.8 (alfa)
#   -Nueva funcin predefinida 'save_EPS'.
# 13-05-03 Versin 0.7 (alfa) [PythonG 2.1-pre6]
#  5-12-02 Versin 0.4 (alfa) [PythonG 2.0u]
#   -Corrige bug: keypressed(2) sin ventana de texto.
#   -window_size() y windows_coordinates() sin parametros
#    devuelven los valores actuales de los mismos.
#   -Nueva func. predef.: clear_output(). Limpia la
#    ventana de texto.
#   -Nueva func. predef.: close_window(). Se cierra todo
#    y termina el programa.
# 19-11-02 Versin 0.3 (alfa)
#   -Corrige bug: faltaba echo en raw_input().
# 14-11-02 Versin 0.2a (alfa)
#   -Cambia tamao de fuente a 13 puntos en linux.
# 31-10-02 Versin 0.2 (alfa)
#   -Versin derivada de 'pythong.py' 2.0h.
# ? Versin inicial 0.1 (alfa)
#   -Versin derivada de 'pythong.py' 2.0g.
#
#----------------------------------------------------------------
#

VERSION="0.8"

if __name__ == "__main__":
  raise "'modulepythong.py' slo puede utilizarse como mdulo."

from Tkinter import *
from string import split,join
import os,os.path,sys,threading,time,imp
import warnings

coordenadaserroneas="Coordenadas de la lnea erroneas"
puntoError="Algn parmetro errneo en create_point"
lineaError="Algn parmetro errneo en create_line"
textoError="Algn parmetro errneo en create_text"
circuloRellenoError="Algn parmetro errneo en create_filled_circle"
rectanguloError="Algn parmetro errneo en create_rectangle"
rectanguloRellenoError="Algn parmetro errneo en create_filled_rectangle"
indiceBorradoError="El indice del objeto que se quiere borrar es erroneo"
moveError="Algn parmetro errneo en move"
abortadoPorUsuario="Abortado por el usuario" 
nombrecolorerroneo="nombre de color erroneo" 

lineaTeclado=''
entradaFormal=0
anchoOrig = altoOrig = 400
tamMundoOrig=1001
posAncla={'CENTER':CENTER,'N':N,'S':S,'E':E,'W':W,
          'NE':NE,'SE':SE,'NW':NW,'SW':SW}
linux=sys.platform[:3]=='lin'

#Clase 'trastero'
class claseVacia: pass

# Funcin que se llama cuando se hace import en un programa
# Evita que se carge modulepythong desde PythonG
def miimport(name, globals=None, locals=None, fromlist=None):
    a=claseVacia()
    a.__dic__={}
    if name=='modulepythong': return a
    
    # Fast path: see if the module has already been imported.
    try: return sys.modules[name]
    except KeyError: pass

    # If any of the following calls raises an exception,
    # there's a problem we can't handle -- let the caller handle it.
    fp, pathname, description = imp.find_module(name)
    try:
        return imp.load_module(name, fp, pathname, description)
    finally:
        # Since we may exit via an exception, close fp explicitly.
        if fp: fp.close()

# -----------------------------------------------------------------
# INI Clase para sustituir a stdin, stdout y stderr en programas --

class Input:
  def __init__(self,pipa_salida):
    self.ps=pipa_salida
    self.buf=[]
    self.cd=0
  def read(self,size):
    global entradaFormal
    if ventana.abortar==2: return ''
    if ventana.abortar==1:
      ventana.abortar=2
      raise abortadoPorUsuario
    entradaFormal = 1
    ventana.mutex.acquire()
    ventana.progS.grab_set()
    ventana.mutex.release()
    x = self.ps.read(size)
    ventana.mutex.acquire()
    ventana.progS.grab_release()
    ventana.mutex.release()
    entradaFormal = 0
    if ventana.abortar==1:
      ventana.abortar=2
      raise abortadoPorUsuario
    return x
  def __getitem__(self,i):
    if len(self.buf)>0:
      x=self.buf[0]
      self.buf=self.buf[1:]
      return x
    elif self.cd==1:
      self.cd=0
      raise IndexError
    self.buf+=self.readlines() #sale con control-D
    if len(self.buf)>0:
      x=self.buf[0]
      self.buf=self.buf[1:]
      return x
    elif self.cd==1:
      self.cd=0
      raise IndexError
  def readline(self):
    if ventana.abortar==2: return ''
    global entradaFormal
    if ventana.abortar==1:
      ventana.abortar=2
      raise abortadoPorUsuario
    ventana.mutex.acquire()
    ventana.progS.grab_set()
    ventana.mutex.release()
    if entradaFormal==1:
      x = self.ps.readline()
    else:
      entradaFormal = 1
      x = self.ps.readline()
      entradaFormal = 0
    ventana.mutex.acquire()
    ventana.progS.grab_release()
    ventana.mutex.release()
    if ventana.abortar==1:
      ventana.abortar=2
      raise abortadoPorUsuario
    return x
  def readlines(self):
    if ventana.abortar==2: return ''
    global entradaFormal
    old = entradaFormal 
    entradaFormal = 1
    res=[]
    lin=self.readline()
    while lin!='':
      if len(lin)>=2 and lin[-2]=='\x04': #Control-D
        lin=lin[0:-2]
        self.cd=1
        entradaFormal = old
        res.append(lin)
        return res
      res.append(lin)
      lin=self.readline()
      
    entradaFormal = old
    return res

class Output:
  def __init__(self): pass
  def write(self,string):
    if ventana.abortar==2: return 
    if ventana.abortar==1:
      ventana.abortar=2
      raise abortadoPorUsuario
    if len(string)<=0: return
    ventana.mutex.acquire()
    try: s=unicode(string,codigoChar)
    except: s=string
    ventana.progS.insert(END,s)
    ventana.progS.mark_set(INSERT,END)
    ventana.progS.see(INSERT)
    ventana.mutex.release()
  def writelines(self,lines):
    for line in lines: self.write(line)

# FIN Clase para sustituir a stdin, stdout y stderr en programas --
# -----------------------------------------------------------------

def ponerBuildins():
  ns={}
  ns['__name__']='__main__'
  ns['__builtins__']=globals().copy()['__builtins__']
  #ns['__builtins__']['__canvas__']=ventana.canvas
  ns['__builtins__']['__execmutex__']=ventana.execmutex
  #ns['__builtins__']['__mutex__']=ventana.mutex
  ns['__builtins__']['window_update']=ventana.window_update
  ns['__builtins__']['__import__']=miimport
  ns['__builtins__']['window_style']=ventana.window_style
  #ns['__builtins__']['newWorkSpace']=ventana.newWorkSpace
  ns['__builtins__']['window_coordinates']=ventana.window_coordinates
  ns['__builtins__']['window_size']=ventana.window_size
  ns['__builtins__']['create_point']=ventana.create_point
  ns['__builtins__']['create_text']=ventana.create_text
  ns['__builtins__']['create_line']=ventana.create_line
  ns['__builtins__']['create_circle']=ventana.create_circle
  ns['__builtins__']['create_filled_circle']=ventana.create_filled_circle
  ns['__builtins__']['create_rectangle']=ventana.create_rectangle
  ns['__builtins__']['create_filled_rectangle']=ventana.create_filled_rectangle
  ns['__builtins__']['erase']=ventana.erase
  ns['__builtins__']['keypressed']=ventana.keypressed
  ns['__builtins__']['mouse_state']=ventana.mouse_state
  ns['__builtins__']['move']=ventana.move
  ns['__builtins__']['clear_output']=ventana.clear_output
  ns['__builtins__']['close_window']=lambda: None
  ns['__builtins__']['set_window_update_mode']=ventana.set_window_update_mode
  ns['__builtins__']['save_EPS']=ventana.save_EPS
  return ns

# -----------------------------------------------------------------
# INI Clase para ejecutar programa como thread --------------------


class MyThread(threading.Thread):
  def run(self):
    global ventana, mensajeError
    x=ventana.codigo
    ruta, nomF = os.path.split(ventana.nombre)
    if nomF=='pythong.py':
      mensajeError=_('No puedo ejecutarme a mi mismo.')
      ventana.ejecucion='err2'
      return
    ns=ponerBuildins()
    try:
      ventana.ejecucion='on'
      try:
        _old_wd=os.getcwd()
        os.chdir(ruta)
      except: pass
      exec x in ns
      ventana.ejecucion='ok'
      os.chdir(_old_wd)
    except abortadoPorUsuario:
      ventana.ejecucion='err1'
      os.chdir(_old_wd)
    except:
      ventana.ejecucion='err2'
      os.chdir(_old_wd)
      tipo,valor,traza = sys.exc_info()
      from StringIO import StringIO
      import traceback
      resTraza=StringIO()
      traceback.print_exception(tipo, valor, traza.tb_next,
                                None, file=resTraza)
      mensajeError = resTraza.getvalue()[:]
      resTraza.close()
      sys.__stderr__.write(mensajeError+'\n')
    ventana.raiz.quit()
         
# FIN Clase para ejecutar programa como thread --------------------
# -----------------------------------------------------------------

class Ventana:
  def __init__(self, tamMundo=tamMundoOrig):
    global ventana,tFuente,conf,reading
    reading=0
    ventana=self
    self.abortar=0

    self.ancho, self.alto = anchoOrig,altoOrig
    self.xinf,self.yinf,self.xsup,self.ysup = 0,0,tamMundo,tamMundo
    self.wum=0
    self.bufTeclado=[]
    self.teclaApretada=0
    self.botonPulsado=0
    self.ultimaTecla=None
    self.ultimoEstadoRaton=(None,None,None)
    
    self.title=self.title2='PythonG %s (modulepythong.py) - Universitat Jaume I de Castell' % VERSION
    self.soloGraf=self.soloGraf2='TODO'
    self.raiz = Tk()
    self.raiz.protocol("WM_DELETE_WINDOW", self.salir)
    self.raiz.title(self.title)
    
    izq=self.izq=Frame(self.raiz,borderwidth=2)
    self.lab1=Label(izq,text='Salida grfica:',anchor=W)
    self.lab1.pack(side=TOP,fill=X)
    self.workspace = Frame(izq,borderwidth=1,relief=SOLID)
    self.canvas=Canvas(self.workspace)
    self.canvas.configure(width=self.ancho, height=self.alto,
                          highlightthickness=0, bg='white',borderwidth=0,
                          relief=FLAT)
    self.canvas.pack(side=TOP,expand=NO)
    self.workspace.pack(side=TOP,expand=NO)
    izq.pack(side=LEFT)
    if linux: tFuente=('lucidatypewritter',13,'bold')
    else:     tFuente=('courier',12,'bold')
    
    der=self.der=Frame(self.raiz,borderwidth=2)
    Label(der,text='Entrada de teclado/Salida de texto:',anchor=W).pack(side=TOP,fill=X)
    fuente = Frame(der,borderwidth=0,relief=FLAT)
    
    self.progS = Text(fuente,borderwidth=0,relief=FLAT)
    self.scrollS = Scrollbar(fuente,command=self.progS.yview,relief=FLAT,
                             highlightthickness=0, takefocus='no')
    self.scrollSx = Scrollbar(der,command=self.progS.xview,
                              relief=FLAT,highlightthickness=0,
                              takefocus='no',orient=HORIZONTAL)
    self.progS.configure(yscrollcommand=self.scrollS.set,
                         xscrollcommand=self.scrollSx.set,
                         font=tFuente,height=1,width=45,
                         foreground='white', background='black',
                         insertbackground='red',insertwidth=3,
                         insertofftime=200, insertontime=500,
                         state=DISABLED,wrap=NONE)
    self.progS.configure(state=NORMAL)
    self.progS.focus_set()
    self.progS.pack(side=LEFT,fill=BOTH,expand=YES)
    self.scrollS.pack(side=RIGHT,fill=Y)
    fuente.pack(side=TOP,fill=BOTH,expand=YES)
    self.scrollSx.pack(side=TOP,fill=X)
    der.pack(side=RIGHT,fill=BOTH,expand=YES)
    self.teclaApretada=0
    self.bufB=[]
    self.mutex = threading.Condition()
    self.mutex.acquire()
    self.raiz.update()
    (self.r,self.w)=os.pipe()
    self.inp=os.fdopen(self.w,"w",0)
    self.out=os.fdopen(self.r,"r",0)
    sys.stdin=Input(self.out)
    sys.stdout=Output()
    #sys.stderr=Output()
    #ventana.raiz.bind('<KeyPress>', ventana.eventoTeclaPulsada)
    #ventana.raiz.bind('<KeyRelease>', ventana.eventoTeclaSoltada)
    ventana.raiz.bind('<Control-c>', ventana.salir)
    ventana.raiz.bind('<Control-C>', ventana.salir)
    self.ancho, self.alto = anchoOrig, altoOrig
    self.escala_x = (self.ancho-1) / float(self.xsup-self.xinf)
    self.escala_y = (self.alto-1)  / float(self.ysup-self.yinf)
    self.canvas.bind('<Motion>',self.eventoRatonMovido)
    self.canvas.bind('<B1-Motion>',self.eventoRatonMovidoB1)
    self.canvas.bind('<B2-Motion>',self.eventoRatonMovidoB2)
    self.canvas.bind('<B3-Motion>',self.eventoRatonMovidoB3)
    self.canvas.bind('<Leave>',self.eventoRatonFuera)
    self.canvas.bind('<ButtonRelease>',self.eventoBotonSoltado)
    self.canvas.bind('<Button-1>',self.eventoBoton1Pulsado)
    self.canvas.bind('<Button-2>',self.eventoBoton2Pulsado)
    self.canvas.bind('<Button-3>',self.eventoBoton3Pulsado)
    self.progS.bind('<KeyPress>',self.eventoTeclaPulsada)
    self.progS.bind('<KeyRelease>', self.eventoTeclaSoltada)
    self.progS.bind('<ButtonPress>',self.NoHacerNada)
    self.progS.bind('<ButtonRelease>',self.NoHacerNada)
    self.progS.bind('<Motion>',self.NoHacerNada)
    self.pre=0
    self.canvas.update()
    self.raiz.update()
    self.xxx=self.canvas.update
    self.canvas.update=lambda: None
    self.mutex.release()
    self.miUpdate()

  def NoHacerNada(self,event=None):
    return "break"

  def salir(self,event=None):
    self.abortar=1
    self.raiz.after(1000, self.raiz.quit)

  def miUpdate(self):
    #sys.__stderr__.write("1->"+`self.pre`+`self.abortar`+"\n")
    if self.abortar!=0 and self.pre==0:
      #sys.__stderr__.write("2\n")
      self.cc=0
    else:
      try:
        #sys.__stderr__.write("3->"+`self.cc`+"\n")
        self.cc+=1
        if self.cc==10:
          self.salir()
      except: pass
    if self.title!=self.title2:
      self.title=self.title2
      self.raiz.title(self.title)
    if self.soloGraf!=self.soloGraf2:
      self.soloGraf=self.soloGraf2
      if self.soloGraf=='G':
        self.der.pack_forget()
        self.lab1.pack_forget()
      else:
        self.der.pack(side=RIGHT,fill=BOTH,expand=YES)
        self.lab1.pack(side=TOP,fill=X)
    self.pre=self.abortar

    self.mutex.acquire()
    self.mutex.wait(0.05)
    self.mutex.acquire()
    #self.raiz.update_idletasks()
    #self.raiz.update() #si se quita se acelera la ejecucin 
                       #falta comprobar efector secundarios
    self.xxx()
    self.mutex.release()
    self.raiz.after(1, self.miUpdate)
  # -----------------------------------------------------------------
  def eventoRatonMovido(self, event, boton=0):
    if self.ejecucion!='on': return "break"
    x = event.x/self.escala_x-self.xinf
    y = self.yinf - (event.y-self.alto+1)/self.escala_y
    #sys.__stderr__.write("(%d %d) (%d %d)\n" % (event.x,event.y,x,y))
    self.ultimoEstadoRaton=(boton,x,y)
    return "break"
  def eventoRatonMovidoB1(self, event):
    if self.ejecucion!='on': return "break"
    return self.eventoRatonMovido(event,1)
  def eventoRatonMovidoB2(self, event):
    if self.ejecucion!='on': return "break"
    return self.eventoRatonMovido(event,2)
  def eventoRatonMovidoB3(self, event):
    if self.ejecucion!='on': return "break"
    return self.eventoRatonMovido(event,3)
  def eventoRatonFuera(self,event):
    if self.ejecucion!='on': return "break"
    self.ultimoEstadoRaton=(None,None,None)
  def eventoBotonPulsado(self,boton,event):
    x = event.x/self.escala_x-self.xinf
    y = self.yinf - (event.y-self.alto+1)/self.escala_y
    self.ultimoEstadoRaton=(boton,x,y)
    return "break"
  def eventoBotonSoltado(self, event):
    self.ultimoEstadoRaton=(0,self.ultimoEstadoRaton[1],self.ultimoEstadoRaton[2])
    if self.ejecucion!='on': return "break"
  def eventoBoton1Pulsado(self, event):
    if self.ejecucion!='on': return "break"
    return self.eventoBotonPulsado(1,event)
  def eventoBoton2Pulsado(self, event):
    if self.ejecucion!='on': return "break"
    return self.eventoBotonPulsado(2,event)
  def eventoBoton3Pulsado(self, event):
    if self.ejecucion!='on': return "break"
    return self.eventoBotonPulsado(3,event)
  # -----------------------------------------------------------------
  def eventoTeclaPulsada(self, event):
    global lineaTeclado, entradaFormal
    if self.abortar!=0: return "break"
    if event.char=='\x03': #Control-c
      self.abortar=1
      if entradaFormal==1: self.inp.write('\n')
      return "break"
    if entradaFormal==1:
      if event.keysym=='Return':
        self.progS.insert(END,'\n')
        self.inp.write(lineaTeclado+'\n')
        lineaTeclado=''
      elif event.keysym=='BackSpace':
        if len(lineaTeclado)>0:
            lineaTeclado =lineaTeclado[:-1]
            self.progS.delete(END+'-2c',END)
      else:
        lineaTeclado=lineaTeclado+event.char
        self.progS.insert(END,event.char)
      self.teclaApretada=1
      return "break"
    else:
      self.ultimaTecla=event.keysym
      self.bufTeclado=[event.keysym]
      #self.bufTeclado.append(event.keysym)
      #if len(self.bufTeclado)>20: self.bufTeclado=self.bufTeclado[-10:]
      self.teclaApretada=1
      return "break"

  def eventoTeclaSoltada(self, event):
    self.teclaApretada=0
  # -------------------------------------------------
  def clear_output(self):
    if self.abortar==2: return 0
    if self.abortar==1:
      self.abortar=2
      raise abortadoPorUsuario
    self.mutex.acquire() #--------
    self.progS.delete('1.0',END)
    if self.wum==1: self.mutex.notify()
    self.mutex.release() #--------
  # -------------------------------------------------
  def save_EPS(self,nombre):
    if self.abortar==2: return 0
    if self.abortar==1:
      self.abortar=2
      raise abortadoPorUsuario
    self.mutex.acquire() #--------
    data=self.canvas.postscript(pagey=430,pagex=297,
                                height=self.alto,width=self.ancho+2,x=-1,
                                pagewidth='20.0c')
    try:
      f=open(nombre,'w')
      try:     f.write(data)
      finally: f.close()
      res=1
    except:
      res=0
    if self.wum==1: self.mutex.notify()
    self.mutex.release() #--------
    return res
  # -------------------------------------------------
  def newWorkSpace(self):
    if self.abortar==2: return 0
    if self.abortar==1:
      self.abortar=2
      raise abortadoPorUsuario
    self.mutex.acquire() #--------
    for i in self.workspace.children.values(): i.destroy()
    #self.raiz.update()
    if self.wum==1: self.mutex.notify()
    self.mutex.release() #--------
    return self.workspace
  # -------------------------------------------------
  def window_size(self,ancho=None,alto=None):
    if self.abortar==2: return 0
    if self.abortar==1:
      self.abortar=2
      raise abortadoPorUsuario
    if ancho==None or alto==None: return [self.ancho,self.alto]
    self.ancho, self.alto = ancho, alto
    self.escala_x = (self.ancho-1) / float(self.xsup-self.xinf)
    self.escala_y = (self.alto-1)  / float(self.ysup-self.yinf)
    self.mutex.acquire() #--------
    try:
      map(self.canvas.delete,self.canvas.find_all())
      self.canvas.configure(width=self.ancho,height=self.alto)
    except TclError: pass
    #self.raiz.update()
    if self.wum==1: self.mutex.notify()
    self.mutex.release() #--------
  # -------------------------------------------------  
  def window_coordinates(self,xinf=None,yinf=None,
                         xsup=None,ysup=None):
    if self.abortar==2: return 0
    if self.abortar==1:
      self.abortar=2
      raise abortadoPorUsuario
    if xinf==None or yinf==None or xsup==None or ysup==None:
      return [self.xinf,self.yinf,self.xsup,self.ysup]
    self.xinf,self.yinf,self.xsup,self.ysup = xinf,yinf,xsup,ysup
    self.escala_x = (self.ancho-1) / float(self.xsup-self.xinf)
    self.escala_y = (self.alto-1)  / float(self.ysup-self.yinf)

    self.mutex.acquire() #--------
    try:   map(self.canvas.delete,self.canvas.find_all())
    except TclError: pass
    #self.raiz.update()
    if self.wum==1: self.mutex.notify()
    self.mutex.release() #--------
  # -------------------------------------------------
  def create_text(self,x,y,cadena,tam=10,ancla='CENTER',color='black',**args):
    if self.abortar==2: return 0
    if self.abortar==1:
      self.abortar=2
      raise abortadoPorUsuario
    args['text']=cadena
    args['anchor']=posAncla[ancla]
    args['fill']=color
    #if linux: args['font']=('lucidatypewritter',tam)
    if linux: args['font']=('courier',tam,'bold')
    else:     args['font']=('courier',int(tam*1.15+2),'bold')
    try:
      xb = (x-self.xinf) * self.escala_x 
      yb = self.alto - 1 - (y- self.yinf) * self.escala_y
    except:
      raise coordenadaserroneas, (x,y)
    self.mutex.acquire() #--------
    try:
      aux = self.canvas.create_text(xb, yb, args)
    except:
      self.mutex.release() #--------
      raise textoError, (x,y,cadena,ancla)
    if self.wum==1: self.mutex.notify()
    self.mutex.release() #--------
    return aux
  # -------------------------------------------------
  def move(self,tags,x,y):
    if self.abortar==2: return 0
    if self.abortar==1:
      self.abortar=2
      raise abortadoPorUsuario
    try:
      xb = x*self.escala_x 
      yb = -y*self.escala_y
    except:
      raise coordenadaserroneas, (x,y)
    self.mutex.acquire() #--------
    try: self.canvas.move(tags,xb,yb)
    except:
      self.mutex.release() #--------
      raise moveError, (tags,x,y)
    if self.wum==1: self.mutex.notify()
    self.mutex.release() #--------
  # -------------------------------------------------  
  def create_line(self,x1,y1,x2,y2,color='black',**args):
    if self.abortar==2: return 0
    if self.abortar==1:
      self.abortar=2
      raise abortadoPorUsuario
    args['fill']=color
    try:
      x1b = (x1-self.xinf) * self.escala_x 
      y1b = self.alto - 1 - (y1- self.yinf) * self.escala_y
      x2b = (x2-self.xinf) * self.escala_x
      y2b = self.alto - 1 - (y2-self.yinf) * self.escala_y
    except:
      raise coordenadaserroneas, (x1,y1,x2,y2)
    self.mutex.acquire() #--------
    try:
      aux = self.canvas.create_line(x1b, y1b, x2b, y2b, args)
    except:
      self.mutex.release() #--------
      raise lineaError, (x1,y1,x2,y2,color)
    if self.wum==1: self.mutex.notify()
    self.mutex.release() #--------
    return aux
  # -----------------------------------------------------------------
  def create_filled_rectangle(self,x1,y1,x2,y2,color='black',relleno=None,**args):
    if self.abortar==2: return 0
    if self.abortar==1:
      self.abortar=2
      raise abortadoPorUsuario
    if relleno==None: relleno=color
    return self.create_rectangle(x1,y1,x2,y2,color,relleno,**args);
  # -----------------------------------------------------------------
  def create_rectangle(self,x1,y1,x2,y2,color='black',relleno=None,**args):
    if self.abortar==2: return 0
    if self.abortar==1:
      self.abortar=2
      raise abortadoPorUsuario
    args['outline']=color
    if relleno!=None: args['fill']=relleno
    try:
      x1b = (x1-self.xinf) * self.escala_x 
      y1b = self.alto - 1 - (y1- self.yinf) * self.escala_y
      x2b = (x2-self.xinf) * self.escala_x
      y2b = self.alto - 1 - (y2-self.yinf) * self.escala_y
    except:
      raise coordenadaserroneas, (x1,y1,x2,y2)
    self.mutex.acquire() #--------
    try:
      aux = self.canvas.create_rectangle(x1b, y1b, x2b, y2b, args)
    except:
      self.mutex.release() #--------
      if relleno!=None:
        raise rectanguloRellenoError, (x1,y1,x2,y2,color,relleno)
      else:
        raise rectanguloError, (x1,y1,x2,y2,color)
    if self.wum==1: self.mutex.notify()
    self.mutex.release() #--------
    return aux
  # -----------------------------------------------------------------
  def create_filled_circle(self,x,y,radio,color='black',relleno=None,**args):
    if self.abortar==2: return 0
    if self.abortar==1:
      self.abortar=2
      raise abortadoPorUsuario
    if relleno==None: relleno=color
    return self.create_circle(x,y,radio,color,relleno,**args);
  # -----------------------------------------------------------------
  def create_circle(self,x,y,radio,color='black',relleno=None,**args):
    if self.abortar==2: return 0
    if self.abortar==1:
      self.abortar=2
      raise abortadoPorUsuario
    args['outline']=color
    if relleno!=None: args['fill']=relleno
    try:
      x1b=(x-self.xinf-radio)* self.escala_x
      x2b=(x-self.xinf+radio)* self.escala_x
      y1b=self.alto - 1 - (y-self.yinf-radio)* self.escala_y
      y2b=self.alto - 1 - (y-self.yinf+radio)* self.escala_y
    except:
      raise coordenadaserroneas, (x,y)
    self.mutex.acquire() #--------
    try:
      aux = self.canvas.create_oval(x1b, y1b, x2b, y2b, args)
    except:
      self.mutex.release() #--------
      if relleno!='no':
        raise circuloRellenoError, (x,y,radio,color,relleno)
      else:
        raise circuloError, (x,y,radio,color)
    if self.wum==1: self.mutex.notify()
    self.mutex.release() #--------
    return aux
  # -----------------------------------------------------------------
  def window_update(self):
    if self.abortar==2: return 0
    if self.abortar==1:
      self.abortar=2
      raise abortadoPorUsuario
    self.mutex.acquire() #--------
    self.mutex.notify()#self.canvas.update()
    self.mutex.release() #--------
  # -----------------------------------------------------------------
  def set_window_update_mode(self,modo):
    self.wum=modo
  # -----------------------------------------------------------------
  def execmutex(self,cad):
    if self.abortar==2: return 0
    if self.abortar==1:
      self.abortar=2
      raise abortadoPorUsuario
    self.mutex.acquire() #--------
    try: exec cad
    except:
      self.mutex.release() #--------
      raise 
    if self.wum==1: self.mutex.notify()
    self.mutex.release() #--------
  # -----------------------------------------------------------------
  def create_point(self,x,y,color='black',**args):
    if self.abortar==2: return 0
    if self.abortar==1:
      self.abortar=2
      raise abortadoPorUsuario
    args['fill']=color
    args['width']=2
    try:
      x1b=(x-self.xinf)*self.escala_x - 0.5
      x2b=x1b+2
      y1b=self.alto - 1 - (y-self.yinf)*self.escala_y
    except:
      raise coordenadaserroneas, (x,y)
    self.mutex.acquire() #--------
    try:
      aux = self.canvas.create_line(x1b, y1b, x2b, y1b,args)
    except:
      self.mutex.release() #--------
      raise puntoError, (x,y,color)
    if self.wum==1: self.mutex.notify()
    self.mutex.release() #--------
    return aux
  # -----------------------------------------------------------------
  def erase(self,indice=None):
    if self.abortar==2: return 0
    if self.abortar==1:
      self.abortar=2
      raise abortadoPorUsuario
    self.mutex.acquire() #--------
    if indice==None:
      try: map(self.canvas.delete,self.canvas.find_all())
      except TclError: pass
    else:
      try:
        self.canvas.delete(indice)
      except:
        self.mutex.release() #--------
        raise indiceBorradoError, indice
    if self.wum==1: self.mutex.notify()
    self.mutex.release() #--------
  # -----------------------------------------------------------------
  def mouse_state(self):
    if self.abortar==2: return
    if self.abortar==1:
      self.abortar=2
      raise abortadoPorUsuario
    return self.ultimoEstadoRaton
  # -----------------------------------------------------------------
  def keypressed(self,retardo=2):
    # 0: No espera, con retardo de repeticion
    # 1: No espera, sin retardo de repeticion (juegos)
    # 2: Espera a que se pulse una tecla, si ya estaba pulsada,
    #    espera a que se suelte antes de leer la correcta.
    if self.abortar==2: return 0
    if self.abortar==1:
      self.abortar=2
      raise abortadoPorUsuario
    if retardo==2:
      while len(self.bufTeclado)==0:
        if self.abortar==2: return 0
        if self.abortar==1:
          self.abortar=2
          raise abortadoPorUsuario
    try:
      x = self.bufTeclado[0]
      self.bufTeclado =  self.bufTeclado[1:]
      return x
    except:
      if self.teclaApretada==1:
        if retardo==0: return None
        return self.ultimaTecla
      return None
  # -------------------------------------------------
  def window_style(self,tit,colorFondo='white',soloGraf='TODO'):
    if self.abortar==2: return 0
    if self.abortar==1:
      self.abortar=2
      raise abortadoPorUsuario
    #return
    self.mutex.acquire() #--------
    self.title2=tit
    self.soloGraf2=soloGraf
    self.canvas.configure(background=colorFondo)
    #self.raiz.title(tit)
    #if soloGraf=='G': self.der.pack_forget()
    if self.wum==1: self.mutex.notify()
    self.mutex.release() #--------
    
Ventana()

frame=sys._getframe(1)
filename = frame.f_code.co_filename
filename=os.path.normcase(os.path.abspath(filename))
ruta,nomFich=os.path.split(filename)
sys.path=[ruta]+sys.path
f=open(filename,'r')
ventana.nombre=filename
ventana.codigo=f.read()+'\n'
f.close()
tPython = MyThread()
tPython.start()

ventana.raiz.mainloop()

sys.stdin=sys.__stdin__
sys.stdout=sys.__stdout__
sys.stderr=sys.__stderr__
tPython.join(2)
#print "isAlive():",tPython.isAlive()
#if tPython.isAlive() and os.name=='posix':
#  import signal
#  os.kill(os.getpid(),signal.SIGKILL)
#else:
#  pass
if tPython.isAlive():
  os.abort()
else:
  sys.exit(1)
