# -*- coding: iso-8859-1 -*-  
import bdb
import os, copy, time, sys
from Tkinter import *

def MensajeConsola(mensaje):
    #sys.__stderr__.write(mensaje)
    pass
    
class Depurador(bdb.Bdb):
    def dispatch_call(self, frame, arg):
        #self.ventana.mostrarMensajeError('DD')
        # XXX 'arg' is no longer used
        if self.botframe is None:
            # First call of dispatch since reset()
            self.botframe = frame.f_back #frame
            return self.trace_dispatch
        if not (self.stop_here(frame) or self.break_anywhere(frame)):
            # No need to trace this function
            return # None
        self.user_call(frame, arg)
        if self.quitting: raise BdbQuit
        return self.trace_dispatch

    def __init__(self, v):
        global ventana, _
        self.versionPython=sys.version_info
        ventana=v
        _ = v.sub
        self.irA_activo=None
        self.VE={}
        self.frame=None
        self.ventana = ventana
        self.ventanacp = self.ventana.prog
        bdb.Bdb.__init__(self)
        self.colorFondo=ventana.raiz.cget('background')
        self.ventanacp.tag_add('CP','0.0','0.0')
        self.m_nombre=self.ventana.nombre
        self.m_prog=self.ventana.prog
        self.make_gui()
        self.kk=None
        MensajeConsola(self.m_nombre+'\n')
        MensajeConsola(self.ventana.exe+'\n')

    def canonic(self, filename):
        # Canonicalize filename -- called by Bdb
        MensajeConsola('->'+filename+'\n')
        if filename=='<string>':
            return self.m_nombre
        return os.path.normcase(os.path.abspath(filename))

    def close(self, event=None):
        self.bframe.destroy()
        self.flocals.destroy()
        self.fglobals.destroy()
        self.pila.destroy()
        self.ventanacp.tag_delete('CP')
        self.ventana.progS.bind('<FocusIn>', self.ventana._focoProg)
        self.ventana.prog.unbind('<FocusIn>')
        aux,nombre=os.path.split(self.m_nombre)
        self.ventana.notebook.selectpage(nombre.replace('_',self.ventana.marca))
        self.ventana.prog.focus_set()
        self.root.unbind('<F7>')
        self.root.unbind('<F8>')
        self.root.unbind('<F4>')
        self.root.unbind('<F5>')        
        self.root.unbind('<F9>')
        self.root.unbind('<F2>')
        self.root.unbind('<Escape>')
        self.todo.destroy()

    def run(self, *args):
        while 1:
          globals=copy.copy(args[1])
          self.hacerReset=0
          self.primera=1
          self.hayerror=0
          self.root.bind('<F7>',self.step_)
          self.root.bind('<F8>',self.next_)
          self.root.bind('<F4>',self.irA_)
          self.root.bind('<F5>',self.ret_)        
          self.root.bind('<F9>',self.cont_)
          self.root.bind('<F2>',self.resetea_)
          self.root.bind('<Escape>',self.quit_)
          res = apply(bdb.Bdb.run, (self, args[0], globals))
          #try: res = apply(bdb.Bdb.run, (self, args[0], globals))
          #except:
          #    x=sys.exc_info()
          #    frame = sys.exc_info()[2].tb_frame.f_back
          #    self.interaction(frame,(x[0], x[1], sys.exc_info()[2].tb_frame))
          #    while 1:pass
          MensajeConsola("-----FIN\n")
          if not self.hacerReset: break
        return res
        #try:
        #    self.interacting = 1
        #    res = apply(bdb.Bdb.run, (self,) + args)
        #finally:
        #    self.interacting = 0

    def user_line(self, frame):
        MensajeConsola("-----1\n")
        code = frame.f_code
        file = self.canonic(code.co_filename)
        #self.ventana.mostrarMensajeError('AA')
        MensajeConsola("[%s]\n" % file)
        MensajeConsola("[%s]\n" % self.ventana.exe)
        if self.ventana.exe==file or (file!='<'+_('annimo')+'>' and not os.path.exists(file)):
            MensajeConsola("-----1a\n")
            self.set_return(frame)
        else:
            MensajeConsola("-----1b\n")
            self.interaction(frame)
    def user_return(self, frame, rv): pass
    def user_exception(self, frame, info): pass # self.interaction(frame, info)

    def make_gui(self):
        ventana = self.ventana
        self.root = ventana.raiz
        self.todo=todo=Frame(ventana.paned.pane('izquierda'),relief=SOLID,
                   borderwidth=2, highlightthickness=0)
        self.flocals = Frame(todo,borderwidth=0, highlightthickness=0)
        self.flocals.pack(side=TOP,expand=NO, fill=X, padx=2, pady=3)
        self.fglobals = Frame(todo, borderwidth=0,highlightthickness=0)
        self.fglobals.pack(side=TOP,expand=NO, fill=X, padx=2, pady=3)
        
        self.bframe=bframe=Frame(todo,borderwidth=2,highlightthickness=0,relief=GROOVE)
        self.buttons = bl = []
        #sys.__stderr__.write(`type(Button)`+' '+`type(_)`+'\n')
        self.bstep = b = Button(bframe, text=_("Paso")+" (F7)",
                                padx=2,command=self.step_)
        bl.append(b)
        self.bnext = b = Button(bframe, text=_("Sig.")+" (F8)",
                                padx=2,command=self.next_)
        bl.append(b)
        self.bret = b = Button(bframe, text=_("Ret.")+" (F5)",
                               padx=2,command=self.ret_)
        bl.append(b)
        self.bcont = b = Button(bframe, text=_("Cont.")+" (F9)",
                                padx=2,command=self.cont_)
        bl.append(b)
        self.birA = b = Button(bframe, text=_("Hasta")+" (F4)",
                               padx=2,command=self.irA_)
        bl.append(b)
        self.breset = b = Button(bframe, text=_("Reset")+" (F2)",
                                 padx=2,command=self.resetea_)
        bl.append(b)
        self.bsalir = b = Button(bframe, text=_("Salir")+" (Esc)",
                                 padx=2,command=self.quit_)
        bl.append(b)
        for b in bl:
            b.configure(state="disabled")
            b.pack(side="left")
        self.bsalir.pack_forget(); self.bsalir.pack(side="right")
        self.breset.pack_forget(); self.breset.pack(side="right")
        self.bframe.pack(side=BOTTOM,fill=X,anchor="w",padx=2,pady=2)
        todo.pack(fill=BOTH,expand=NO,padx=2,pady=4)
        #
        self.root.bind('<F7>',self.step_)
        self.root.bind('<F8>',self.next_)
        self.root.bind('<F4>',self.irA_)
        self.root.bind('<F5>',self.ret_)        
        self.root.bind('<F9>',self.cont_)
        self.root.bind('<F2>',self.resetea_)
        self.root.bind('<Escape>',self.quit_)
        #
        self.pila = Frame(ventana.paned.pane('derecha'),relief=SOLID,
                            height=1,borderwidth=2,highlightthickness=0)
        self.pila.pack(side=BOTTOM,expand=NO,fill=X,padx=2,pady=2)
        Label(self.pila, text=_("Pila"),
              borderwidth=2, relief="groove").pack(side=TOP,fill=X,padx=2,pady=2)
        self.fstack=Frame(self.pila,height=1)
        self.fstack.pack(side=TOP,expand=NO,fill=X,padx=2)
        #
        self.show_stack()
        self.show_locals()
        self.show_globals()

    def _pre_interaction(self, frame, info=None):
        #self.ventana.mostrarMensajeError('AA')
        self.frame = frame
        code = frame.f_code
        file = code.co_filename
        base = os.path.basename(file)
        lineno = frame.f_lineno
        #
        message = "%s:%s" % (base, lineno)
        if code.co_name != "?":
            message = "%s: %s()" % (message, code.co_name)

        self.ventana.progS.bind('<FocusIn>', self.ventana._focoProg)
        self.ventana.prog.unbind('<FocusIn>')
        self.show_variables(1)
        self.ventana.raiz.update_idletasks()
        self.sync_source_line()
        MensajeConsola("-----2\n")
        #
        if info:
            type, value, tb = info
            try: m1 = type.__name__
            except AttributeError: m1 = "%s" % str(type)
            if value is not None:
                try: m1 = "%s: %s" % (m1, str(value))
                except: pass
            if m1!="Abortado por el usuario":  
                self.root.unbind('<F7>')
                self.root.unbind('<F8>')
                self.root.unbind('<F4>')
                self.root.unbind('<F5>')        
                self.root.unbind('<F9>')
                for b in self.buttons[:-2]: b.configure(state="disabled")
                self.hayerror=1
                self.ventana.mostrarMensajeError(m1)
                #code = frame.f_code
                #self.sync_source_line(code)
        else:
            MensajeConsola("-----3\n")
            m1 = ''
            tb = None
        #
        sv = self.stackviewer
        if sv:
            stack, i = self.get_stack(self.frame, tb)
            sv.load_stack(stack, i)
        if self.hayerror==0:
            for b in self.buttons: b.configure(state="normal")
        else:
            for b in self.buttons[-2:]: b.configure(state="normal")
        MensajeConsola("-----4\n")

        #self.ventana.mostrarMensaje(`self.breaks`)
        if self.irA_activo!=None:
            file, lineno=self.irA_activo
            self.clear_break(file, lineno)
            self.irA_activo=None

        self.ventana.prog.focus_set()
        MensajeConsola("-----5\n")
        
    def interaction(self, frame, info=None):
        if self.primera and self.versionPython[0]<=2 and self.versionPython[1]<=2:
            self.primera=0
            self.set_step()
            return
        #if info:
        #    self.set_step()
        #    return
        self.pre_interaction=lambda f=frame, i=info: self._pre_interaction(f,i)
        self.ventana.hacerPaso=1
        while self.kk==None:
            time.sleep(0.05)
            if self.ventana.abortar!=0:
                self.set_quit()
                self.ventana.raiz.quit() # y si no est en mainloop?
                                         # siempre est sino no pillara C-c C-c 
                self.ventana.hacerPaso=0
                return
        self.ventana.hacerPaso=0
        self.ventana.mutex.acquire() #-----------
        
        for b in self.buttons: b.configure(state="disabled")
        MensajeConsola("-----5b\n")
        self.kk()
        self.kk=None
        MensajeConsola("-----6\n")
        self.ventana.prog.bind('<FocusIn>', self.ventana._focoProgS)
        self.ventana.progS.unbind('<FocusIn>')
        self.ventana.progS.focus_set()

        self.ventana.mutex.release() #-----------
        self.frame = None
        MensajeConsola("-----7\n")

    def sync_source_line(self,code=None):
        if not self.frame: return
        if code==None: code = self.frame.f_code
        file = code.co_filename
        lineno = self.frame.f_lineno
        MensajeConsola("[%s]\n" % file)
        if lineno>0:
            MensajeConsola("lineo>0\n")
            self.ventanacp.tag_delete('CP')
        if file == '<string>':
            MensajeConsola("file=='<string>'\n")
            aux,nombre=os.path.split(self.m_nombre)
            self.ventana.notebook.selectpage(nombre.replace('_',self.ventana.marca))
        else:
            MensajeConsola("file!='<string>'\n")
            try:
                aux,nombre=os.path.split(file)
                self.ventana.notebook.selectpage(nombre.replace('_',self.ventana.marca))
            except:
                self.ventana.nombre=os.path.normcase(os.path.abspath(file))
                MensajeConsola("XX [%s]\n" % self.ventana.nombre)
                self.ventana.insdelprog='on'
                self.ventana.abrirFichero(None,0)
                self.ventana.insdelprog='off'
        if lineno>0:
            self.ventanacp=self.ventana.prog
            self.ventanacp.tag_add('CP',str(lineno)+'.0',str(lineno+1)+'.0')
            self.ventanacp.tag_configure('CP',foreground='white',background='blue')
            self.ventana.prog.see(str(lineno+1)+'.0')
            if lineno>1: self.ventana.prog.see(str(lineno-1)+'.0')
            self.ventana.prog.mark_set(INSERT,str(lineno)+'.0')

    def cont_(self,event=None): self.kk=self.cont; self.root.quit()
    def step_(self,event=None): self.kk=self.step; self.root.quit()
    def next_(self,event=None): self.kk=lambda x=self.frame: self.next(x); self.root.quit()
    def ret_(self,event=None):  self.kk=lambda x=self.frame: self.ret(x); self.root.quit()
    def quit_(self,event=None): self.kk=self.quit; self.root.quit()
    def resetea_(self,event=None): self.kk=self.resetea; self.root.quit()
    def irA_(self,event=None):  self.kk=self.irA; self.root.quit()
        
    def cont(self,event=None): self.set_continue()
    def step(self,event=None): self.set_step()
    def next(self,event=None): self.set_next(self.frame)
    def ret(self,event=None): self.set_return(self.frame)
    def quit(self,event=None): self.set_quit()

    def resetea(self,event=None):
        self.hacerReset=1
        self.set_quit()

    def irA(self,event=None):
        file,lineno = self.set_breakpoint_here(self.ventana.prog)
        self.irA_activo=[file,lineno]
        self.set_continue()

    def nuevaVE(self):
        texto='mat'
        self.VE[texto]=''
    def borraVE(self,texto):
        try: del self.VE[texto] 
        except: pass
        
    stackviewer = None

    def show_stack(self):
        if not self.stackviewer:
            self.stackviewer = sv = StackViewer(self.fstack, self)
            if self.frame:
                stack, i = self.get_stack(self.frame, None)
                sv.load_stack(stack, i)
        else:
            sv = self.stackviewer
            if sv:
                self.stackviewer = None
                sv.close()
            self.fstack['height'] = 1

    def show_frame(self, (frame, lineno)):
        self.frame = frame
        self.show_variables()
        
    localsviewer = None
    globalsviewer = None

    def show_locals(self):
        lv = self.localsviewer
        if not lv:
            self.localsviewer = NamespaceViewer(self.flocals,
                            _("Variables locales"), self.colorFondo)
        self.show_variables()

    def show_globals(self):
        gv = self.globalsviewer
        if not gv:
            self.globalsviewer = NamespaceViewer(self.fglobals,
                            _("Variables globales"), self.colorFondo)
        self.show_variables()

    def show_variables(self, force=0):
        lv = self.localsviewer
        gv = self.globalsviewer
        frame = self.frame
        if not frame:
            ldict = gdict = None
        else:
            ldict = frame.f_locals
            gdict = frame.f_globals
            if lv and gv and ldict is gdict:
                ldict = None
        if lv:
            lv.load_dict(ldict, force)
        if gv:
            gv.load_dict(gdict, force)

    def set_breakpoint_here(self, prog):
        filename = self.ventana.nombre
        lineno =int(prog.index(INSERT).split('.')[0])
        msg = self.set_break(filename, lineno)
        if msg:
            self.ventana.mostrarMensajeError(msg)
            prog.bell()
            return [None, None]
        return [filename,lineno]
        #text.tag_add("BREAK", "insert linestart", "insert lineend +1char")

    # A literal copy of Bdb.set_break() without the print statement at the end
    def set_break(self, filename, lineno, temporary=0, cond = None):
        import linecache # Import as late as possible
        line = linecache.getline(filename, lineno)
        if not line:
            return 'That line does not exist!'
        if not self.breaks.has_key(filename):
            self.breaks[filename] = []
        list = self.breaks[filename]
        if not lineno in list:
            list.append(lineno)
        bp = bdb.Breakpoint(filename, lineno, temporary, cond)

##    def dispatch_line(self, frame):
##        if self.irA_activo!=None:
##            if self.break_here(frame):
##                self.user_line(frame)
##                if self.quitting: raise BdbQuit
##            return self.trace_dispatch
##        if self.stop_here(frame) or self.break_here(frame):
##            self.user_line(frame)
##            if self.quitting: raise BdbQuit
##        return self.trace_dispatch

class ScrolledList:

    default = "(None)"

    def __init__(self, master, **options):
        # Create top frame, with scrollbar and listbox
        self.master = master
        self.frame = frame = Frame(master)
        self.frame.pack(fill=X, expand=1)
        self.vbar = vbar = Scrollbar(frame, name="vbar")
        self.vbar.pack(side="right", fill="y")
        self.listbox = listbox = Listbox(frame, exportselection=0,
            background=self.browser.colorFondo,height=4,relief=FLAT,
            borderwidth=0,highlightthickness=0)
        if options:
            listbox.configure(options)
        listbox.pack(expand=NO, fill=X)
        # Tie listbox and scrollbar together
        vbar["command"] = listbox.yview
        listbox["yscrollcommand"] = vbar.set
        # Bind events to the list box
        listbox.bind("<ButtonRelease-1>", self.click_event)
        listbox.bind("<Double-ButtonRelease-1>", self.double_click_event)
        listbox.bind("<Key-Up>", self.up_event)
        listbox.bind("<Key-Down>", self.down_event)
        # Mark as empty
        self.clear()

    def close(self):
        self.frame.destroy()

    def clear(self):
        self.listbox.delete(0, "end")
        self.empty = 1
        self.listbox.insert("end", self.default)

    def append(self, item):
        if self.empty:
            self.listbox.delete(0, "end")
            self.empty = 0
        #sys.__stderr__.write(`item`+'\n')
        if type(item)==type(u''):
            item=item.encode(ventana.codigoChar)
        self.listbox.insert("end", str(item))

    def get(self, index):
        return self.listbox.get(index)

    def click_event(self, event):
        self.listbox.activate("@%d,%d" % (event.x, event.y))
        index = self.listbox.index("active")
        self.select(index)
        self.on_select(index)
        return "break"

    def double_click_event(self, event):
        index = self.listbox.index("active")
        self.select(index)
        self.on_double(index)
        return "break"

    def up_event(self, event):
        index = self.listbox.index("active")
        if self.listbox.selection_includes(index):
            index = index - 1
        else:
            index = self.listbox.size() - 1
        if index < 0:
            self.listbox.bell()
        else:
            self.select(index)
            self.on_select(index)
        return "break"

    def down_event(self, event):
        index = self.listbox.index("active")
        if self.listbox.selection_includes(index):
            index = index + 1
        else:
            index = 0
        if index >= self.listbox.size():
            self.listbox.bell()
        else:
            self.select(index)
            self.on_select(index)
        return "break"

    def select(self, index):
        self.listbox.focus_set()
        self.listbox.activate(index)
        self.listbox.selection_clear(0, "end")
        self.listbox.selection_set(index)
        self.listbox.see(index)

    # Methods to override for specific actions
    def on_select(self, index): pass
    def on_double(self, index): pass

class StackViewer(ScrolledList):

    def __init__(self, master, browser):
        self.browser = browser
        ScrolledList.__init__(self, master, width=80)
        self.stack = []

    def load_stack(self, stack, index=None):
        self.stack = stack
        self.clear()
        if len(stack)>4:
            #self.vbar.pack(side="right", fill=Y)
            self.listbox["height"] = 4
            self.listbox.pack(expand=YES)
        else:
            #self.vbar.pack_forget()
            self.listbox["height"] = len(stack)
            self.listbox.pack(expand=NO)
            
        for i in range(len(stack))[1:]:
            frame, lineno = stack[i]
            try:    modname = frame.f_globals["__name__"]
            except: modname = "?"
            code = frame.f_code
            filename = code.co_filename
            funcname = code.co_name
            filename=os.path.normcase(os.path.abspath(filename))
            import linecache
            sourceline = linecache.getline(filename, lineno)
            sourceline = sourceline.strip()
            if modname=='__main__':
                r,nom=os.path.split(self.browser.m_nombre)
                try: modname=nom.decode(ventana.codigoChar)
                except: modname=nom
                sourceline = linecache.getline(self.browser.m_nombre, lineno)
                sourceline = unicode(sourceline.strip(),ventana.codigoChar)
            if funcname in ("?", "", None):
                item = ("[%s] "+_('Lnea')+" %d: %s") % (modname, lineno,sourceline)
            else:
                item = ("[%s.%s(...)] "+_('Lnea')+" %d: %s") % (modname, funcname,
                                                    lineno, sourceline)
                #item = "%s: %s() [lnea %d]" % (modname, funcname, lineno)
            if i == index:
                item = "> " + item
            self.append(item)
        if index is not None:
            self.select(index)

    def on_select(self, index):
        if 0 <= index < len(self.stack)-1:
            self.browser.show_frame(self.stack[index+1])

    def on_double(self, index):
        self.show_source(index)

    def show_stack_frame(self):
        index = self.listbox.index("active")
        if 0 <= index < len(self.stack)-1:
            self.browser.show_frame(self.stack[index+1])

    def show_source(self, index):
        if not (0 <= index < len(self.stack)-1):
            return
        frame, lineno = self.stack[index+1]
        code = frame.f_code
        self.browser.sync_source_line(code)
        return

class NamespaceViewer:

    def __init__(self, master, title, colorFondo, dict=None):
        width = 0
        height = 40
        if dict:
            height = 20*len(dict) # XXX 20 == observed height of Entry widget
        self.master = master
        self.title = title
        self.colorFondo=colorFondo
        from repr import Repr
        self.repr = Repr()
        self.repr.maxstring = 60
        self.repr.maxother = 60
        #self.repr.maxdict = 10
        #self.repr.maxlist = 30
        #self.repr.maxtuple = 30
        self.frame = frame = Frame(master)
        self.frame.pack(expand=NO, fill=X, padx=2, pady=2)
        self.label = Label(frame, text=title, borderwidth=2, relief="groove")
        self.label.pack(fill=X)
        self.vbar = vbar = Scrollbar(frame, name="vbar")
        #vbar.pack(side="right", fill=Y)
        self.canvas = canvas = Canvas(frame, highlightthickness=0, bg=colorFondo,
                                      height=min(100, max(40, height)),
                                      scrollregion=(0, 0, width, height))
        canvas.pack(side="left", fill=BOTH, expand=YES,padx=2)
        vbar["command"] = canvas.yview
        canvas["yscrollcommand"] = vbar.set
        self.subframe = subframe = Frame(canvas)
        self.sfid = canvas.create_window(0, 0, window=subframe, anchor="nw")
        self.load_dict(dict)

    dict = -1

    def load_dict(self, dict, force=0):
        if dict is self.dict and not force:
            return
        subframe = self.subframe
        frame = self.frame
        for c in subframe.children.values():
            c.destroy()
        self.dict = None
        if not dict:
            self.master.pack_forget()
            #return 
            #l = Label(subframe, text="None")
            #l.grid(row=0, column=0)
        else:
            self.master.pack(side=BOTTOM, expand=NO, fill=X)
            global row
            row = 0
            self.mostrarVariables(subframe,dict)
            if row==0:
               l = Label(subframe, text="")
               l.grid(row=0, column=0)

        self.dict = dict
        # XXX Could we use a <Configure> callback for the following?
        subframe.update_idletasks() # Alas!
        width = subframe.winfo_reqwidth()
        height = subframe.winfo_reqheight()
        canvas = self.canvas
        if height > 100:
            self.vbar.pack(side="right", fill=Y)
            self.canvas["scrollregion"] = (0, 0, width, height)
            canvas["height"] = 100
            frame.pack(expand=YES)
        else:
            self.vbar.pack_forget()
            canvas["height"] = height
            frame.pack(expand=NO)

    def close(self):
        self.frame.destroy()

    def mostrarVariables(self,subframe,dict):
        global row
        names = dict.keys()
        names.sort()
        for name in names:
            if name[:2]=='__' and name[-2:]=='__': continue
            value = dict[name]
            import types
            if type(value) in [types.FunctionType, types.ModuleType,
                               types.BuiltinFunctionType, types.ClassType]: continue
            if type(value)==types.InstanceType:
                value=value.__dict__
                svalue = '<'+_('Instancia')+': '+self.repr.repr(value)[1:-1]+'>' # repr(value)
            else:
                svalue = self.repr.repr(value) # repr(value)
            l = Label(subframe, text=name+': ')
            l.grid(row=row, column=0, sticky="w")
##            l = Label(subframe, text=svalue, justify="l", wraplength=300)
            try: # linux
              l = Entry(subframe, width=0, borderwidth=0, highlightthickness=0,
                        disabledbackground=self.colorFondo,
                        disabledforeground='black', relief=FLAT)
            except TclError: # windows
              l = Entry(subframe, width=0, borderwidth=0, highlightthickness=0,
                        background=self.colorFondo,
                        foreground='black', relief=FLAT)
            l.insert(0, svalue)
            l["state"] = "disabled"
            l.grid(row=row, column=1, sticky="w")
            row = row+1
        return row
