#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-  
#
# 'pythong.py' es un sencillo entorno para Python,
# extendido con capacidades grficas, de lectura de
# teclado y un sencillo depurador.
#
# Copyright (C) 2003 Universitat Jaume I (Castello, Spain)
#
# LICENCIA:
# Este programa es Software Libre; usted puede redistribuirlo
# y/o modificarlo bajo los trminos de la "GNU General Public
# License" versin 2, como lo publica la "FSF Free Software
# Foundation" 
#
# Este programa es distribuido con la esperanza de que le ser
# til, pero SIN NINGUNA GARANTIA; incluso sin la garanta
# implcita por el MERCADEO o EJERCICIO DE ALGUN PROPOSITO en
# particular. Vea la "GNU General Public License" para ms
# detalles.
#
# Usted debe haber recibido una copia de la "GNU General Public
# License" junto con este programa, si no, escriba a la "FSF
# Free Software Foundation, Inc.", 59 Temple Place - Suite 330,
# Boston, MA  02111-1307, USA.
#
#----------------------------------------------------------------
#
# AUTOR: David Llorens (dllorens@lsi.uji.es)
#        Dpto. de Lenguajes y Sistemas Informticos
#        Universitat Jaume I
#        Castell (Spain)
# LICENCIA: GPL versin 2
# FECHA: 4-Diciembre-2003
#
# OBSERVACIONES: Este programa incorpora cdigo del programa IDLE de
#       Guido van Rossum (http://www.python.org/doc/Copyright.html).
#
# PROGRAMA:
#  Ver directorio MANUAL
# REQUISITOS:
#  Ver directorio MANUAL
# POR HACER:
#  -Hacer que 'keypressed' llame a mainloop (para funcionar en interprete)
#  -Evitar 'DeprecationWarning' al ejecutar programas fuera del entorno.
#  -Poder terminar la ejecucion de programas con bucles infinitos sin
#   tener que cerrar PythonG.
# CHANGELOG:
#  Ver directorio MANUAL
#----------------------------------------------------------------
#

#Impide utilizar pythong.py como mdulo
if __name__ != '__main__': raise "'pythong.py' can't be imported"

VERSION="2.1.5"
activarCodDebug=1
activarIdioma=1

#Comprueba la version de python instalada
import sys
if sys.hexversion < 0x020100F0:
  raise "ERROR: PythonG needs a python version >= 2.1"

#Importa lo necesario
import os, threading
import codecs, webbrowser, locale
from cStringIO import StringIO
from string import split,join,replace,find
from time import sleep
from code import InteractiveInterpreter
from traceback import print_exception
#Averigua desde dnde se ejecuta PythonG para que pueda importar
#los mdulos 'Pmw' y 'fromidle'
fullpath = os.path.normcase(os.path.abspath(os.path.dirname(sys.argv[0])))
sys.path = [fullpath+'/libpythong']+sys.path+['.']
import Pmw
from fromidle import *
sys.path.append(os.getcwd())

# Se utiliza 'marca' para sustituir internamente por el caracter '_'
# de cara a PmwNotebook.py
marca='{;)'

#Averigua S.O.
posix = (os.name=='posix')

# Clases para excepciones propias
class AbortadoPorUsuario(Exception): pass
class CoordenadasErroneas(Exception): pass
class ErrorIndiceBorrado(Exception): pass
class ErrorEnParametro(Exception):
  def __init__(self, f, c): self.f,  self.c = f, c
  def __str__(self): return self.f+repr(self.c)
class MiError(Exception): pass

fichConf = 'pythong.cfg' # ser '.pythong.cfg' en unix
fichWeb = 'pythong.html' # ser '.pythong.html' en unix
try:
  from pwd import getpwuid
  home=getpwuid(os.getuid())[5]
  if len(home)>0 and home[-1]!='/': home=home+'/.'
  else: home=home+'.'
except: # windows no tiene getuid()
  home='C:/'

# -----------------------------------------------------------------
# INI Funciones para manejar el fichero de configuracin ----------
conf = {}

def ponerConfDefecto():
  global conf
  conf={}
  conf['VERSION']=''
  if posix: conf['fuente_nombre']='lucidatypewritter'
  else:     conf['fuente_nombre']='courier'
  conf['fuente_tam']='13'
  conf['fuente_grosor']='bold'
  conf['color_pordefecto']  ={"foreground":'palegreen',"background":'black'}
  conf['color_comentario']  ={"foreground":'white', "background":'black'}
  conf['color_palabraclave']={"foreground":'red',   "background":'black'}
  conf['color_predefinidas']={"foreground":'cyan',  "background":'black'}
  conf['color_cadenas']     ={"foreground":'orange',"background":'black'}
  conf['color_definicion']  ={"foreground":'yellow',"background":'black'}
  conf['color_salida']      ={"foreground":'white', "background":'black'}
  conf['color_sync']        ={"foreground":'blue',  "background":'black'}
  conf['salida_grafica']='on'
  conf['ocultar_fuentes_en_ejecucion']='off'
  conf['ocultar_salidas_en_edicion']='off'
  conf['idioma']='entorno'
  
def leerConfiguracion():
  global conf,home
  ponerConfDefecto()
  # lee el fichero de configuracin
  try:
    f=open(home+fichConf,'r')
    try:     lineas=f.read()
    finally: f.close()
    for l in lineas.split('\n'):
      if l=='': continue
      opconf=l.split()
      if not conf.has_key(opconf[0]): raise MiError, "formato_erroneo"
      if len(opconf)==2:  conf[opconf[0]]=opconf[1]
      elif len(opconf)==3:
        conf[opconf[0]]={'foreground':opconf[1],'background':opconf[2]}
      else: raise MiError, "formato_erroneo"
    if conf['VERSION']!=VERSION: raise MiError, "version_erronea"
  except:
    ponerConfDefecto()

def guardarConfiguracion():
  global home,conf
  conf['VERSION'] = VERSION
  try: f=open(home+fichConf,'w')
  except: return
  if ventana.ocultarSG.get()=='0': conf['salida_grafica']='on'
  else: conf['salida_grafica']='off'
  if ventana.ocultarFuentes.get()=='0': conf['ocultar_fuentes_en_ejecucion']='off'
  else: conf['ocultar_fuentes_en_ejecucion']='on'
  if ventana.ocultarSalidas.get()=='0': conf['ocultar_salidas_en_edicion']='off'
  else: conf['ocultar_salidas_en_edicion']='on'
  lclaves=conf.keys()
  lclaves.sort()
  try: 
    for clave in lclaves:
      if type(conf[clave])==type(''):
        f.write("%s %s\n"% (clave, conf[clave]))
      elif type(conf[clave])==type({}):
        f.write("%s %s %s\n"% (clave, conf[clave]['foreground'],
                               conf[clave]['background']))
      else: raise MiError, "error guardando configuracin"
  finally:
    f.close()

# FIN Funciones para manejar el fichero de configuracin ----------
# -----------------------------------------------------------------

leerConfiguracion()

#INI Fija el idioma----------------------------------------
if conf['idioma']=='entorno':
  try:
    idiomaSel=locale.getdefaultlocale()[0].split('@')[0].split('.')[0]
  except:
    idiomaSel='es_ES'
else:
  idiomaSel=conf['idioma']

# Idioma de los botones por defecto del Tk y mensajes sistema
# Actualmente no tiene cataln -> pasa a ingls
try: os.putenv('LANG',idiomaSel)
except: pass

try:
  import gettext
  i18n = gettext.translation('pythong',fullpath+'/libpythong/i18n/',[idiomaSel])
  i18n_ca = gettext.translation('pythong',fullpath+'/libpythong/i18n/',['ca_ES'])
  i18n_en = gettext.translation('pythong',fullpath+'/libpythong/i18n/',['en_US'])
  #print i18n
  i18n.install(unicode=0)
  #print 'ok',idiomaSel
except:
  def _(m): return m

for codigoChar in ['iso8859-15','iso8859-1','latin-1']:
  try:
    codecs.getencoder(codigoChar)
    break
  except: pass

x_x=_

def _(m):
  try: m2=m.decode(codigoChar)
  except: m2=m
  zz = x_x(m2)
  try: res = zz.decode(codigoChar)
  except: res = zz
  return res

try:
  locale.setlocale(locale.LC_CTYPE, 'C') # obliga a variables es ASCII
  #locale.setlocale(locale.LC_CTYPE, 'es_ES@euro') # lo contrario
except:
  pass # en MS-Windows no funciona la lnea anterior

from Tkinter import *
import tkFileDialog,tkFont 
import tkMessageBox

# Version corregida de tkMessageBox.askyesno (bug en python 2.3.2)
def askyesno(title=None, message=None, **options):
    "Ask a question; return true if the answer is yes"
    s = tkMessageBox._show(title, message, tkMessageBox.QUESTION,
                           tkMessageBox.YESNO, **options)
    try:
      if s in [True,False]: return s
      else: return s == 'yes'
    except:
      return s == 'yes'

#FIN Fija el idioma----------------------------------------

fichXdef='pythongXdef'

raiz=Tk()

#Si existe, carga el fichero de recursos .pythongXdef
try: raiz.option_readfile(home+fichXdef)
except: pass

Pmw.initialise(raiz)

#direcciones url
url_webPythonG = 'http://www3.uji.es/~dllorens/PythonG/'
url_docPython = 'http://www.python.org/doc/current/'
url_docFuncPG = 'file://'+fullpath+'/MANUAL/funcpredefs.html'

#Variables Globales
mensajeError = u''
lineaTeclado = []
entradaFormal = 0
anchoOrig = altoOrig = [400,300,250,200]
tamMundoOrig = 1001
posAncla ={'CENTER':CENTER,'N':N,'S':S,'E':E,'W':W,
           'NE':NE,'SE':SE,'NW':NW,'SW':SW}


#Clase 'trastero'
class claseVacia: pass

# Funcin que se llama cuando se hace import en un programa
# Evita que se carge modulepythong desde PythonG
importOriginal=globals()['__builtins__'].__import__
def miimport(name,globals=None, locals=None, fromlist=None):
  global ventana
  a=claseVacia()
  a.__dic__={}
  if name=='modulepythong': return a
  try:
    return sys.modules[name]
  except KeyError: pass
  return importOriginal(name,globals, locals, fromlist)

#Funcion para convertir saltos de linea a \n
def convierte_saltos_de_linea(temp):
  return temp.replace('\r\n', '\n').replace('\r', '\n')

class Mi_readline:
  def __init__(self,texto):
    self.lineas=texto.split('\n')
    self.pos=-1
  def readline(self):
    try:
      self.pos+=1
      return self.lineas[self.pos]+'\n'
    except:
      return ''
          
# -----------------------------------------------------------------
# INI Clase para sustituir a stdin, stdout y stderr en programas --

class Input:
  def __init__(self,pipa_salida):
    self.ps=pipa_salida
    self.buf=[]
    self.cd=0
  def read(self,size):
    global entradaFormal
    if ventana.abortar==2: return ''
    if ventana.abortar==1:
      ventana.abortar=2
      raise AbortadoPorUsuario
    entradaFormal = 1
    ventana.mutex.acquire()
    ventana.progS.grab_set()
    ventana.mutex.release()
    x = self.ps.read(size)
    ventana.mutex.acquire()
    ventana.progS.grab_release()
    ventana.mutex.release()
    entradaFormal = 0
    if ventana.abortar==1:
      ventana.abortar=2
      raise AbortadoPorUsuario
    return unicode(x,'utf8').encode(codigoChar)
  def __getitem__(self,i):
    if len(self.buf)>0:
      x=self.buf[0]
      self.buf=self.buf[1:]
      return x
    elif self.cd==1:
      self.cd=0
      raise IndexError
    self.buf+=self.readlines() #sale con control-D
    if len(self.buf)>0:
      x=self.buf[0]
      self.buf=self.buf[1:]
      return x
    elif self.cd==1:
      self.cd=0
      raise IndexError
  def readline(self):
    if ventana.abortar==2: return ''
    global entradaFormal
    if ventana.abortar==1:
      ventana.abortar=2
      raise AbortadoPorUsuario
    ventana.mutex.acquire()
    ventana.progS.grab_set()
    ventana.mutex.release()
    if entradaFormal==1:
      x = self.ps.readline()
    else:
      entradaFormal = 1
      x = self.ps.readline()
      entradaFormal = 0
    ventana.mutex.acquire()
    ventana.progS.grab_release()
    ventana.mutex.release()
    if ventana.abortar==1:
      ventana.abortar=2
      raise AbortadoPorUsuario
    return unicode(x,'utf8').encode(codigoChar)
  def readlines(self):
    if ventana.abortar==2: return ''
    global entradaFormal
    old = entradaFormal 
    entradaFormal = 1
    res=[]
    lin=self.readline()
    while lin!='':
      if len(lin)>=2 and lin[-2]=='\x04': #Control-D
        lin=lin[0:-2]
        self.cd=1
        entradaFormal = old
        res.append(lin)
        return res
      res.append(lin)
      lin=self.readline()
      
    entradaFormal = old
    return res

class Output:
  def __init__(self): pass
  def write(self,string):
    if ventana.abortar==2: return 
    if ventana.abortar==1:
      ventana.abortar=2
      raise AbortadoPorUsuario
    if len(string)>0:
      ventana.mutex.acquire()
      if type(string)==type(u''):
        s=string
      else:
        try: s=unicode(string,codigoChar)
        except: s=string
      ventana.progS.insert(END,s)
      ventana.progS.mark_set(INSERT,END)
      ventana.progS.see(INSERT)
      ventana.mutex.release()
  def writelines(self,lines):
    for line in lines: self.write(line)

# FIN Clase para sustituir a stdin, stdout y stderr en programas --
# -----------------------------------------------------------------

# -----------------------------------------------------------------
# INI Clase para sustituir a stdin, stdout y stderr en intrprete -
      
class InputP:
  def __init__(self,pipa_salida=None): self.ps=pipa_salida
  def read(self,size): return "read"
  def readline(self):
    global reading
    ventana.mutex.acquire()
    index=split(ventana.p.pestanya.index(INSERT),'.')
    ventana.mutex.release()
    save = reading
    try:
      reading = 1
      ventana.raiz.mainloop()
    finally:
      reading = save
    ventana.mutex.acquire()
    texto=ventana.p.pestanya.get(join(index,'.'),
                                 index[0]+'.end')
    ventana.mutex.release()
    # en mi pc ya es unicode y se ejecuta el except
    try: t=unicode(texto,'utf8') 
    except: t=texto
    # lo pasa a nuestro charset
    try: t2=t.encode(codigoChar)
    except: t2=t
    return t2+'\n'
  def readlines(self):
    res=[]
    lin=self.readline()
    while lin!='':
      res.append(lin)
      lin=self.readline()
    return res
  def isatty(self): return 1

class OutputP:
  def __init__(self): pass
  def write(self,string):
    if ventana.abortar==2: return 
    if ventana.abortar==1:
      ventana.abortar=2
      raise AbortadoPorUsuario
    if len(string)>0:
      ventana.mutex.acquire()
      if type(string)==type(u''):
        s=string
      else:
        try: s=unicode(string,codigoChar)
        except:
          try: s=unicode(string,'utf8')
          except: s=string    
      ventana.listaProg['<python>'].pestanya.insert(END,s)
      ventana.listaProg['<python>'].pestanya.mark_set(INSERT,END)
      ventana.listaProg['<python>'].pestanya.see(INSERT)
      ventana.mutex.release()
  def writelines(self,lines):
    for line in lines: self.write(line)
  def flush(self):  pass
  def isatty(self): return 1

# FIN Clase para sustituir a stdin, stdout y stderr en intrprete -
# -----------------------------------------------------------------

def ponerBuildins():
  ns={}
  ns['__name__']='__main__'
  ns['__builtins__']=globals().copy()['__builtins__']
  #ns['__builtins__'].__canvas__=ventana.canvas
  ns['__builtins__'].__execmutex__=ventana.execmutex
  ns['__builtins__'].__v__=ventana
  #ns['__builtins__'].__mutex__=ventana.mutex
  ns['__builtins__'].window_update=ventana.window_update
  ns['__builtins__'].__import__=miimport
  ns['__builtins__'].window_style=ventana.window_style
  #ns['__builtins__'].newWorkSpace=ventana.newWorkSpace
  ns['__builtins__'].window_coordinates=ventana.window_coordinates
  ns['__builtins__'].window_size=ventana.window_size
  ns['__builtins__'].create_point=ventana.create_point
  ns['__builtins__'].create_text=ventana.create_text
  ns['__builtins__'].create_line=ventana.create_line
  ns['__builtins__'].create_circle=ventana.create_circle
  ns['__builtins__'].create_filled_circle=ventana.create_filled_circle
  ns['__builtins__'].create_rectangle=ventana.create_rectangle
  ns['__builtins__'].create_filled_rectangle=ventana.create_filled_rectangle
  ns['__builtins__'].erase=ventana.erase
  ns['__builtins__'].keypressed=ventana.keypressed
  ns['__builtins__'].mouse_state=ventana.mouse_state
  ns['__builtins__'].move=ventana.move
  ns['__builtins__'].clear_output=ventana.clear_output
  ns['__builtins__'].close_window=lambda: None
  ns['__builtins__'].set_window_update_mode=ventana.set_window_update_mode
  ns['__builtins__'].save_EPS=ventana.save_EPS
  return ns

# -----------------------------------------------------------------
# INI Clase para ejecutar programa como thread --------------------
      
class MyThread(threading.Thread):
  def run(self):
    global ventana, mensajeError
    x=ventana.codigo
    ruta, nomF = os.path.split(ventana.nombre)
    if nomF=='pythong.py':
      mensajeError=_('No puedo ejecutarme a mi mismo.')
      ventana.ejecucion='err2'
      return
    ns=ponerBuildins()
    listaModulosOrig=sys.modules.keys()
    try:
      ventana.ejecucion='on'
      try:
        _old_wd=os.getcwd()
        os.chdir(ruta)
      except: pass
      exec x in ns
      ventana.ejecucion='ok'
      os.chdir(_old_wd)
    except AbortadoPorUsuario:
      ventana.ejecucion='err1'
      os.chdir(_old_wd)
    except:
      ventana.ejecucion='err2'
      os.chdir(_old_wd)
      tipo,valor,traza = sys.exc_info()
      resTraza=StringIO()
      print_exception(tipo, valor, traza.tb_next,
                      None, file=resTraza)
      mensajeError = resTraza.getvalue()[:].decode('latin-1')
      resTraza.close()
    listaNueva=sys.modules.keys()
    for elem in listaNueva:
      if elem not in listaModulosOrig:
          del sys.modules[elem]
          
# FIN Clase para ejecutar programa como thread --------------------
# -----------------------------------------------------------------

# -----------------------------------------------------------------
# INI Clase para depurar programa como thread --------------------
      
class MyThreadDebug(threading.Thread):
  def run(self):
    global ventana, mensajeError
    x=ventana.codigo
    ruta, nomF = os.path.split(ventana.nombre)
    if nomF=='pythong.py':
      mensajeError=_('No puedo ejecutarme a mi mismo.')
      ventana.ejecucion='err2'
      return
    ns=ponerBuildins()
    listaModulosOrig=sys.modules.keys()
    try:
      ventana.ejecucion='on'
      ventana.depuracion='on'
      try:
        _old_wd=os.getcwd()
        os.chdir(ruta)
      except: pass
      
      try:
        ventana.dep.run(x,ns)
      finally: 
        os.chdir(_old_wd)
      ventana.ejecucion='ok'
    except AbortadoPorUsuario:
      ventana.ejecucion='err1'
      #os.chdir(_old_wd)
    except: # Quitar "kk"
      ventana.ejecucion='err2'
      #os.chdir(_old_wd)
      tipo,valor,traza = sys.exc_info()
      resTraza=StringIO()
      print_exception(tipo, valor, traza.tb_next.tb_next.tb_next,
                      None, file=resTraza)
      mensajeError = resTraza.getvalue()[:].decode('latin-1')
      resTraza.close()
    #ventana.dep.close()
    listaNueva=sys.modules.keys()
    for elem in listaNueva:
      if elem not in listaModulosOrig:
          del sys.modules[elem]
          
# FIN Clase para depurar programa como thread --------------------
# -----------------------------------------------------------------

# -----------------------------------------------------------------
# INI Clase para mostrar los errores del thread en ejecucin ------

class MostrarError:
  def __init__(self, parent, mensaje):
    top = self.top = Toplevel(parent)
    self.parent = parent
    top.title(_('Error de ejecucin'))
    top.transient(parent)
    top.protocol("WM_DELETE_WINDOW", self.cancel)
    top.geometry("+%d+%d" % (parent.winfo_rootx()+50,
                             parent.winfo_rooty()+50))
    if posix:
      Label(top, text=mensaje, anchor=W, justify=LEFT,
            font=('lucidatypewritter',13,'bold')).pack()
    else:
      Label(top, text=mensaje, anchor=W, justify=LEFT,
            font=('courier',12,'bold')).pack()
    b = Button(top, text="OK", command=self.ok)
    b.pack()
    top.bind("<Return>", self.ok)
    top.bind("<Escape>", self.cancel)
    top.grab_set()
    b.focus_set()
    top.wait_window()
    ventana.raiz.update()
  def ok(self, event=None):
    ventana.prog.focus_set()
    self.top.destroy()
  def cancel(self, event=None):
    ventana.prog.focus_set()
    self.top.destroy()

# FIN Clase para mostrar los errores del thread en ejecucin ------
# -----------------------------------------------------------------


# -----------------------------------------------------------------
# INI Clase principal de PythonG ----------------------------------

class Ventana:
  def __init__(self, nomFich=[], tamMundo=tamMundoOrig):
    global ventana,tFuente,conf,grSizeDefecto
    ventana=self
    self.marca=marca
    self.sub=_
    self.codigoChar=codigoChar
    self.depuracion='off'
    self.ejecucion='off'
    self.insdelprog='on'
    self.tabgen=0
    self.quererSalir=0
    self.wum=0
    self.exe=os.path.normcase(os.path.abspath(sys.argv[0]))
    self.xinf,self.yinf,self.xsup,self.ysup = 0,0,tamMundo,tamMundo
    self.abortar=0
    self.bufTeclado=[]
    self.teclaApretada=0
    self.ultimaTecla=None
    self.ultimoEstadoRaton=(None,None,None)

    self.raiz = raiz
    self.res=[self.raiz.winfo_screenwidth(),self.raiz.winfo_screenheight()]
    if self.res[0]>=1400 and self.res[1]>=1050:
      self.tamIni=[1260,912]
      grSizeDefecto=0
      #self.tamIni=[924,668]
      #grSizeDefecto=1
      #self.tamIni=[750,500]
      #grSizeDefecto=2
      #self.tamIni=[600,400]
      #grSizeDefecto=3
    elif self.res[0]>=1024 and self.res[1]>=768:
      self.tamIni=[924,668]
      grSizeDefecto=1
    elif self.res[0]>=800 and self.res[1]>=600:
      self.tamIni=[700,500]
      grSizeDefecto=2
    elif self.res[0]>=640 and self.res[1]>=480:
      self.tamIni=[600,400]
      grSizeDefecto=3
    else:
      self.mostrarMensajeError(_('PythonG necesita para ejecutarse una resolucin de pantalla de, al menos, 640x480 pixels (la actual es de %dx%d)') %
                               (self.res[0],self.res[1]))
      return
    self.ancho, self.alto = anchoOrig[grSizeDefecto],altoOrig[grSizeDefecto]
    self.raiz.geometry('%dx%d'%(self.tamIni[0],self.tamIni[1]))
    self.raiz.protocol("WM_DELETE_WINDOW", self.salir)
    self.raiz.minsize(width=600,height=400)
    self.raiz.title('PythonG %s - Universitat Jaume I de Castell' % VERSION)
    self.raiz.iconname('PythonG')
    #self.raiz.overrideredirect(1)
    #w, h = self.raiz.winfo_screenwidth(), self.raiz.winfo_screenheight()
    #self.raiz.geometry("%dx%d+0+0" % (w, h))
    
    self.tagdefs = {
      "COMMENT": conf['color_comentario'],
      "KEYWORD": conf['color_palabraclave'],
      "PREDEFS": conf['color_predefinidas'],
      "STRING":  conf['color_cadenas'],
      "DEFINITION": conf['color_definicion'],
      "SYNC": conf['color_pordefecto'],
      "TODO": conf['color_pordefecto'],
      "BREAK": conf['color_pordefecto'],
      # The following is used by ReplaceDialog:
      "hit": {"foreground":'black',"background":'white'}
      }

    self.listaTamFuente=[]
    old=-5
    self.posListaTamFuente=-1
    aux2=int(conf['fuente_tam'])
    for i in range(4,30):
      f = tkFont.Font(family=conf['fuente_nombre'], size=i,
                      weight=conf['fuente_grosor'])
      aux = f.metrics()
      if aux!=old:
        self.listaTamFuente.append(i)
        if aux2!=-1 and i>=aux2:
          aux2=-1
          self.posListaTamFuente=len(self.listaTamFuente)-1
        old=aux
    if self.posListaTamFuente==-1:
      self.posListaTamFuente=int(len(self.listaTamFuente))/2
      conf['fuente_tam']=str(self.listaTamFuente[self.posListaTamFuente])
      
    try:
      tFuente=(conf['fuente_nombre'],int(conf['fuente_tam']),conf['fuente_grosor'])
    except:
      conf['fuente_grosor']='bold'
      if posix:
        conf['fuente_tam']='13'
        conf['fuente_nombre']='lucidatypewritter'
      else:
        conf['fuente_tam']='10'
        conf['fuente_nombre']='courier'
      tFuente=(conf['fuente_nombre'],int(conf['fuente_tam']),conf['fuente_grosor'])

    self.tecla = None
    self.bufB=[]
    self.mutex = threading.Condition()
    
    self.ocultarFuentes=StringVar()
    if conf['ocultar_fuentes_en_ejecucion']=='on': self.ocultarFuentes.set('1')
    else: self.ocultarFuentes.set('0')
    self.ocultarSG=StringVar()
    if conf['salida_grafica']=='on': self.ocultarSG.set('0')
    else:  self.ocultarSG.set('1')
    self.ocultarSalidas=StringVar()
    if conf['ocultar_salidas_en_edicion']=='on': self.ocultarSalidas.set('1')
    else:  self.ocultarSalidas.set('0')
    self.linea=StringVar()
    self.nombreRuta=StringVar()
    self.nombreRuta.set('')
    self.tamIzq = 0
    self.tamDer = 0
    self.tamPaux=0
    self.ponObjetos()
    self.tamFuenteD=self.tamDer
    self.cambioOcultarSalidas=None
    if self.ocultarSalidas.get()=='1':
      self.paned.configurepane('derecha',max=self.tamFuenteD,min=self.tamFuenteD)
      self.paned.configurepane('derecha',max=100000,min=0)
    #if conf['ocultar_salidas_en_edicion']=='on':
    #  self.paned.configurepane('derecha',max=0)
    self.idcanvas=self.workspace.children.keys()
    if len(self.idcanvas)==0: raise MiError, "error"
    self.listaProg={}
    self.aux_stdout=sys.stdout
    self.aux_stderr=sys.stderr
    self.aux_stdin=sys.stdin

    try: nomFich.remove('<python>')
    except ValueError: pass
    try: nomFich.remove('<'+_('annimo')+'>')
    except ValueError: pass

    self.ponBarraMensajes('')
    #abrir pestaa python shell
    global reading 
    reading=0
    self.nombre='<python>'
    self.nuevaPestanya('<python>',None)
    self.p = self.listaProg['<python>']
    self.teclaPythonReset()
    
    for n in nomFich:
      self.nombre=os.path.normcase(os.path.abspath(n))
      self.abrirFichero(None,0)

    self.miUpdate()
    self.posC=self.tPrevia=None
    
    self.progS.configure(height=1)
    if nomFich==[]:
      self.mostrarMensaje(_("Bienvenido [ utilizando cdigo %s ]") %codigoChar)
    self.raiz.mainloop()

  def ponerBindingsProg(self):
    self.tPrevia=None
    self.raiz.bind('<KeyPress>', self.teclaP)
    self.raiz.bind('<Control-c>', self.teclaControl_c)
    self.raiz.bind('<Control-C>', self.teclaControl_c)
    if activarCodDebug:
      self.prog.bind('<Control-d>', self.teclaControl_d)
      self.prog.bind('<Control-D>', self.teclaControl_d)
    self.prog.bind('<Escape>', self.teclaEscape)
    self.prog.bind('<percent>', self.teclaPorcentaje)
    self.prog.bind('<Return>', self.teclaReturn)
    self.prog.bind('<Tab>', self.teclaTabulador)
    self.prog.bind('<BackSpace>', self.teclaRetroceso)
    self.prog.bind('<colon>', self.teclaDosPuntos)
    self.prog.bind('<Alt-w>', self.copiarSel)
    self.prog.bind('<Alt-W>', self.copiarSel)
    self.prog.bind('<Control-v>', self.pegarSel)
    self.prog.bind('<Control-V>', self.pegarSel)
    self.prog.bind('<Control-x>', self.cortarSel)
    self.prog.bind('<Control-X>', self.cortarSel)
    self.prog.bind('<Control-n>', self.teclaControl_n)
    self.prog.bind('<Control-N>', self.teclaControl_n)
    self.prog.bind('<Control-k>', self.teclaControl_k)
    self.prog.bind('<Control-K>', self.teclaControl_k)
    self.prog.bind('<Control-s>', self.teclaControl_s)
    self.prog.bind('<Control-S>', self.teclaControl_s)
    self.prog.bind('<Control-f>', self.teclaControl_f)
    self.prog.bind('<Control-F>', self.teclaControl_f)
    self.prog.bind('<Control-w>', self.teclaControl_w)
    self.prog.bind('<Control-W>', self.teclaControl_w)
    self.prog.bind('<Key-k>', self.teclaCerrar)
    self.prog.bind('<Key-K>', self.teclaCerrar)
    self.prog.bind('<Key-g>', self.teclaIrA)
    self.prog.bind('<Key-G>', self.teclaIrA)
    self.raiz.bind('<Control-minus>', self.teclaFuenteP)
    self.raiz.bind('<Control-plus>', self.teclaFuenteG)
    self.raiz.bind('<Alt-Left>', self.paginaPrevia)
    self.raiz.bind('<Alt-Right>', self.paginaSiguiente)
    self.prog.bind('<Control-less>', self.teclaControl_less)
    self.prog.bind('<Control-greater>', self.teclaControl_greater)
    try:
      self.raiz.bind('<Control-KP_Subtract>', self.teclaFuenteP)
      self.raiz.bind('<Control-KP_Add>', self.teclaFuenteG)
      self.raiz.bind('<KP_Enter>', self.teclaKP_Enter)
      self.raiz.bind('<Alt-KP_Left>', self.paginaPrevia)
      self.raiz.bind('<Alt-KP_Right>', self.paginaSiguiente)
    except: pass

  def teclaKP_Enter(self,event=None):
    self.raiz.event_generate('<Return>')
    return "break"

  def teclaControl_less(self,event=None):
    self.tPrevia=None
    self.dedentarSel()
    return "break"
    
  def teclaControl_greater(self,event=None):
    self.tPrevia=None
    self.indentarSel()
    return "break"
    
  def quitarBindingsProg(self):
    self.tPrevia=None
    if self.ejecucion!='on':
      self.raiz.unbind('<KeyPress>')
      self.raiz.unbind('<Control-c>')
      self.raiz.unbind('<Control-C>')
    self.prog.unbind('<Escape>')
    self.prog.unbind('<percent>')
    self.prog.unbind('<Return>')
    self.prog.unbind('<Tab>')
    self.prog.unbind('<BackSpace>')
    self.prog.unbind('<colon>')
    self.prog.unbind('<Alt-w>')
    self.prog.unbind('<Alt-W>')
    self.prog.unbind('<Control-v>')
    self.prog.unbind('<Control-V>')
    self.prog.unbind('<Control-x>')
    self.prog.unbind('<Control-X>')
    self.prog.unbind('<Control-n>')
    self.prog.unbind('<Control-N>')
    self.prog.unbind('<Control-k>')
    self.prog.unbind('<Control-K>')
    self.prog.unbind('<Control-s>')
    self.prog.unbind('<Control-S>')
    self.prog.unbind('<Control-f>')
    self.prog.unbind('<Control-F>')
    self.prog.unbind('<Control-w>')
    self.prog.unbind('<Control-W>')
    self.prog.unbind('<Key-k>')
    self.prog.unbind('<Key-K>')
    self.prog.unbind('<Key-g>')
    self.prog.unbind('<Key-G>')
    #self.prog.unbind('<greater>')
    #self.prog.unbind('<less>')
    self.raiz.unbind('<Control-minus>')
    self.raiz.unbind('<Control-plus>')
    self.raiz.unbind('<Alt-Left>')
    self.raiz.unbind('<Alt-Right>')
    try:
      self.raiz.unbind('<Control-KP_Subtract>')
      self.raiz.unbind('<Control-KP_Add>')
      self.raiz.unbind('<KP_Enter>')
      self.raiz.unbind('<Alt-KP_Left>')
      self.raiz.unbind('<Alt-KP_Right>')
    except: pass
        

  def paginaPrevia(self,event=None):
    if (self.ejecucion=='on' or self.depuracion=='on') and \
       self.notebook.index(Pmw.SELECT)==1:
      return "break"
    self.notebook.previouspage()
    return "break"

  def paginaSiguiente(self,event=None):
    self.notebook.nextpage()
    return "break"

  def teclaP(self,event=None):
    #if not self.ejecucion: self.mostrarMensaje('')
    #print "YY",self.tPrevia,self.posC
    #print "YY [%s][%s]" %(event.keysym,self.prog.index(INSERT))
    if self.posC!=split(self.prog.index(INSERT),'.'):
      self.tPrevia=None
    self.posC=split(self.prog.index(INSERT),'.')

  def teclaEscape(self,event=None):
    index=split(self.prog.index(INSERT),'.')
    self.posC=index
    self.tPrevia="Escape"

  def teclaPorcentaje(self,event=None):
    index=split(self.prog.index(INSERT),'.')
    if self.tPrevia=='Escape' and self.posC==index:
      self.posC=index
      self.tPrevia=None
      self.ponReemplazar()
      return "break"
    self.posC=index
    self.tPrevia=None
      
  def teclaCerrar(self,event=None):
    index=split(self.prog.index(INSERT),'.')
    if self.tPrevia=="Control-x" and self.posC==index:
      self.posC=index
      self.tPrevia=None
      self.cerrarFichero()
      return "break"
    self.posC=index
    self.tPrevia=None
    
  def teclaIrA(self,event=None):
    index=split(self.prog.index(INSERT),'.')
    if self.tPrevia=="Escape" and self.posC==index:
      self.posC=index
      self.tPrevia=None
      self.ponIrA()
      return "break"
    self.posC=index
    self.tPrevia=None

  def indentarSel(self):
    try:
      ini=split(self.prog.index(SEL_FIRST),'.')
      fin=split(self.prog.index(SEL_LAST),'.')
      if ini==fin: return
      if fin[1]=='0': linea=int(fin[0])-1
      else:           linea=int(fin[0])
    except TclError: return
    try:
      r=range(int(ini[0]),linea+1)
    except ValueError: return
    for i in r:
      if self.prog.get(str(i)+'.0', str(i)+'.2')!='':
        self.prog.insert(str(i)+'.0', '  ')
    self.prog.see(INSERT)
    
  def dedentarSel(self):
    try:
      ini=split(self.prog.index(SEL_FIRST),'.')
      fin=split(self.prog.index(SEL_LAST),'.')
      if ini==fin: return
      if fin[1]=='0': linea=int(fin[0])-1
      else:           linea=int(fin[0])
    except TclError: return
    try:
      r=range(int(ini[0]),linea+1)
    except: return
    pos=1
    for i in r:
      lin=self.prog.get(str(i)+'.0', str(i)+'.2')
      if lin!='  ' and lin!=' ' and lin!='':
        pos=0
        break
    if pos==1:
      for i in r:
        if self.prog.get(str(i)+'.0', str(i)+'.2')!='':
          self.prog.delete(str(i)+'.0', str(i)+'.2')
    self.prog.see(INSERT)

  def comentarSel(self):
    ini=split(self.prog.index(SEL_FIRST),'.')
    fin=split(self.prog.index(SEL_LAST),'.')
    if len(fin)<2: return
    if fin[1]=='0':
      fin[0]=str(int(fin[0])-1)
    try:
      r=range(int(ini[0]),int(fin[0])+1)
    except ValueError: return
    for i in r:
      self.prog.insert(str(i)+'.0', '##')
    aux=self.prog.index(INSERT)
    self.prog.event_generate('<Left>')
    self.prog.mark_set(INSERT,aux)
    self.prog.see(INSERT)

  def descomentarSel(self):
    ini=split(self.prog.index(SEL_FIRST),'.')
    fin=split(self.prog.index(SEL_LAST),'.')
    if len(fin)<2: return
    if fin[1]=='0':
      fin[0]=str(int(fin[0])-1)
    try:
      r=range(int(ini[0]),int(fin[0])+1)
    except: return
    for i in r:
      lin=self.prog.get(str(i)+'.0', str(i)+'.2')
      if lin=='##':
        self.prog.delete(str(i)+'.0', str(i)+'.2')
    aux=self.prog.index(INSERT)
    self.prog.event_generate('<Left>')
    self.prog.mark_set(INSERT,aux)
    self.prog.see(INSERT)
        
  def teclaControl_c(self,event=None):
    global entradaFormal
    index=split(self.prog.index(INSERT),'.')
    if self.tPrevia=="Control-x" and self.posC==index:
      self.tPrevia=None
      if self.depuracion=='on':
        self.abortar=1
        self.dep.quit()
        self.quererSalir=1
      else:
        self.salir()
    elif self.tPrevia=="Control-c" and self.posC==index and self.nombre!='<python>':
      self.tPrevia=None
      if self.ejecucion=='off': self.ejecutar()
      elif self.abortar==0:
        self.abortar=1
        if entradaFormal==1: self.inp.write('\n')
        elif self.depuracion=='on': self.dep.quit()
    else:
      if self.nombre=='<python>':
        if self.presalir==0:
          self.p.int.runsource('raise KeyboardInterrupt')
          self.p.texto_incomp=''
          self.p.int.write('>>> ')
          index=split(self.p.pestanya.index(INSERT),'.')
          self.p.pestanya.see(index[0]+'.0')
        else: self.salir()
        return "break"
      try: texto = self.prog.get(SEL_FIRST,SEL_LAST)
      except: texto=''
      if len(texto)==0:
        self.tPrevia="Control-c"
      else:
        self.tPrevia=None
        self.copiarSel(event)
    self.posC=index
    return "break"

  def teclaControl_w(self,event=None):
    index=split(self.prog.index(INSERT),'.')
    if self.tPrevia=="Control-x" and self.posC==index:
      self.salvarFicheroComo(None,1)
    self.posC=index
    self.tPrevia="Control-w" 

  def teclaControl_s(self,event=None):
    index=split(self.prog.index(INSERT),'.')
    if self.tPrevia=="Control-x" and self.posC==index:
      self.posC=index
      self.tPrevia=None
      self.salvarFicheroComo(None,0)
      return "break"
    else:
      self.buscarPos=self.prog.index(INSERT)
      self.posC=index
      self.tPrevia=None
      self.ponBuscar()
      return "break"

  def teclaControl_d(self,event=None):
    index=split(self.prog.index(INSERT),'.')
    if self.tPrevia=="Control-c" and self.posC==index:
      self.depurar()
    self.posC=index
    self.tPrevia="Control-d"
    return "break"

  def teclaControl_n(self,event=None):
    index=split(self.prog.index(INSERT),'.')
    if self.tPrevia=="Control-x" and self.posC==index:
      self.nuevoFichero()
    self.posC=index
    self.tPrevia="Control-n" 

  def teclaControl_f(self,event=None):
    index=split(self.prog.index(INSERT),'.')
    if self.tPrevia=="Control-x" and self.posC==index:
      self.abrirFichero()
    self.posC=index
    self.tPrevia="Control-f" 

  def teclaControl_k(self,event=None):
    index=split(self.prog.index(INSERT),'.')
    texto=self.prog.get(INSERT,index[0]+'.end')
    if len(texto)>0:
      if self.posC!=index or self.tPrevia!="Control-k":
        self.raiz.clipboard_clear()
      self.raiz.clipboard_append(texto)
      self.prog.delete(INSERT,index[0]+'.'+str(int(index[1])+len(texto)))
    else:
      self.raiz.clipboard_append('\n')
      self.prog.delete(INSERT,str(int(index[0])+1)+'.0')
    self.posC=index
    self.tPrevia="Control-k"
    return "break"

  def teclaRetroceso(self,event=None):
    index=split(self.prog.index(INSERT),'.')
    c=int(index[1])
    lin=self.prog.get(index[0]+'.0',index[0]+'.end')
    if lin[0:c]==' '*c and c>1:
      self.prog.delete(index[0]+'.'+str(c-2),index[0]+'.'+str(c))
    elif c>0:
      self.prog.delete(index[0]+'.'+str(c-1),index[0]+'.'+str(c))
    elif c==0: return
    self.prog.see(index[0]+'.0')
    self.prog.see(INSERT)
    return "break"
  
  def teclaDosPuntos(self,event=None):
    self.prog.insert(INSERT,':')
    palsdp=['else','elif','except','finally']
    index=split(self.prog.index(INSERT),'.')
    texto=self.prog.get(index[0]+'.0',index[0]+'.end')
    pals=split(split(replace(replace(texto,'(',' ('),':',' :'),'#')[0])
    #print texto,pals
    if len(pals)>0 and pals[0] in palsdp:
      self.tabgen=1
      self.prog.event_generate('<Tab>')
    self.prog.see(INSERT)
    return "break"
  
  def teclaTabulador(self,event=None):
    if self.nombre=='<python>':
      self.prog.insert(INSERT,'  ')
      self.prog.see(INSERT)
      return "break"
    index=split(self.prog.index(INSERT),'.')
    nl=int(index[0])
    if nl==1: return "break"
    #mira la indentacin de la linea anterior
    linP2=''
    while len(split(linP2))==0 and nl>1:
      linP2=self.prog.get(str(nl-1)+'.0',str(nl-1)+'.end')
      nl=nl-1
    indP=0
    for c in linP2:
      if c==' ': indP=indP+1
      else: break
    desindentar=0
    # si la linea anterior es 'return','raise','pass','break', la actual esta desindentada
    linP=split(split(replace(linP2,'(',' ('),'#')[0])
    if len(linP)>0:
      if len(linP[-1])>0 and linP[-1][-1]==':': indP=indP+2
      elif (linP[0] in ['return','raise','pass','break']) and indP>=2:
        desindentar=1
        indP=indP-2
    #mira la indentacin de la linea actual
    lin=self.prog.get(index[0]+'.0',index[0]+'.end')
    ind=0
    for c in lin:
      if c==' ': ind=ind+1
      else: break
    # si la linea actual es 'else','else:','elif' , la actual esta desindentada
    lin2=split(split(replace(lin,'(',' ('),'#')[0])
    #print lin2
    if len(lin2)>0 and len(linP)>0:
      if indP>=2 and desindentar==0:
        
        if (lin2[0] in ['else','else:','elif'] and linP[0] not in ['if','elif']) or \
               (lin2[0] in ['except','except:'] and linP[0] not in ['try','try:']):
          desindentar=1
          indP=indP-2
      
    if indP-ind>0 and self.tabgen==0:
      self.prog.insert(index[0]+'.0',' '*(indP-ind))
    if ind-indP>0:
      self.prog.delete(index[0]+'.0',index[0]+'.%d' % (ind-indP))
      #ventana.progS.mark_set(INSERT,INSERT+'+%dc' % (ind-indP))
      #self.prog.mark_set(INSERT,INSERT+'+%dc' % (ind-indP))
    index=split(self.prog.index(INSERT),'.')
    #print "ZZ",int(index[1]), indP, ind
    if int(index[1])<indP:
      self.prog.mark_set(INSERT, index[0]+'.%d'%indP)
    self.prog.see(INSERT)
    if self.tabgen==1: self.tabgen=0
    return "break"
  
  def teclaReturn(self,event=None):
    #self.prog.insert(INSERT,'\n')
    index=split(self.prog.index(INSERT),'.')
    palsD=split(self.prog.get(index[0]+'.'+index[1],index[0]+'.end'))
    palsI=split(self.prog.get(index[0]+'.0',index[0]+'.'+index[1]))
    if len(palsI)==0 and len(palsD)>0:
      self.prog.insert(index[0]+'.0','\n')
      self.prog.mark_set(INSERT,str(int(index[0])+1)+'.'+index[1])
    else:
      self.prog.insert(INSERT,'\n')
      if len(palsI)+len(palsD)!=0: self.prog.event_generate('<Tab>')
    self.prog.see(index[0]+'.0')
    self.prog.see(INSERT)
    return "break"

  #teclas de cortar, copiar y pegar.
  def pegarSel(self,event=None):
    index=split(self.prog.index(INSERT),'.')
    try: texto = self.prog.selection_get(selection='CLIPBOARD')
    except: texto=''
    if len(texto)==0:
      self.tPrevia="Control-v"
      self.posC=index
      return "break"
    self.prog.insert(INSERT, texto)
    self.prog.see(INSERT)
    self.tPrevia=None
    self.posC=index
    return "break"
  def copiarSel(self,event=None):
    index=split(self.prog.index(INSERT),'.')
    try: texto = self.prog.get(SEL_FIRST,SEL_LAST)
    except: texto='' 
    if len(texto)==0:
      self.tPrevia="Alt-w"
      self.posC=index
      return "break"
    self.raiz.clipboard_clear()
    self.raiz.clipboard_append(texto)
    self.tPrevia=None
    self.posC=index
  def cortarSel(self,event=None):
    index=split(self.prog.index(INSERT),'.')
    try: texto=self.prog.get(SEL_FIRST,SEL_LAST)
    except: texto='' 
    if len(texto)==0:
      self.tPrevia="Control-x"
      self.posC=index
      return "break"
    self.raiz.clipboard_clear()
    self.raiz.clipboard_append(texto)
    self.prog.delete(SEL_FIRST,SEL_LAST)
    self.tPrevia=None
    self.posC=index
    return "break"

  #teclas de aumentar y reducir fuentes
  def teclaFuenteG(self,event=None):
    global tFuente,conf
    if self.posListaTamFuente==len(self.listaTamFuente)-1: return "break"
    else: self.posListaTamFuente = self.posListaTamFuente+1
    conf['fuente_tam']=str(self.listaTamFuente[self.posListaTamFuente])
    tFuente=(conf['fuente_nombre'],int(conf['fuente_tam']),conf['fuente_grosor'])
    for i in self.listaProg:
      self.listaProg[i].pestanya.configure(font=tFuente)
    self.progS.configure(font=tFuente)
    self.mostrarMensaje(_('Seleccionada fuente de %s puntos.') % conf['fuente_tam'])
    return "break"
  def teclaFuenteP(self,event=None):
    global tFuente,conf
    if self.posListaTamFuente==0: return "break"
    else: self.posListaTamFuente = self.posListaTamFuente-1
    conf['fuente_tam']=str(self.listaTamFuente[self.posListaTamFuente])
    tFuente=(conf['fuente_nombre'],int(conf['fuente_tam']),conf['fuente_grosor'])
    for i in self.listaProg:
      self.listaProg[i].pestanya.configure(font=tFuente)
    self.progS.configure(font=tFuente)
    self.mostrarMensaje(_('Seleccionada fuente de %s puntos.') % conf['fuente_tam'])
    return "break"

  # Inicio bindings del entry de 'Buscar' e 'Ir a...'
  def Buscar_teclaControl_s(self,event=None):
    entry=self.status.component('entry')
    aux=entry.get()
    self.buscarTecla='Return2'
    if aux=='':
      try: entry.insert(INSERT,self.cadBuscar)
      except: pass
    entry.event_generate('<Return>')
    return "break"
  def BuscarIr_teclaEscape(self,event=None):
    entry=self.status.component('entry')
    self.buscarTecla='Escape'
    entry.event_generate('<Return>')
    return "break"

  # Restaura barra mensajes donde se situa 'entry' de 'Buscar...',
  # 'Reemplazar...' e 'Ir a...'
  def ponBarraMensajes(self,men):
    try: self.status.destroy()
    except: pass
    try: self.bMensaje.destroy()
    except: pass
    self.bMensaje = Label(self.msg2, text=men,height=1,
                          anchor=W,borderwidth=3,relief=FLAT)
    self.bMensaje.pack(side=BOTTOM,fill=X,expand=NO)

  def mostrarMensaje(self,men):
    #self.mutex.acquire()
    self.bMensaje.configure(text=men)
    #self.mutex.release()

  def mostrarMensajeError(self,men):
    #self.mutex.acquire()
    tkMessageBox.showerror(_('Error'),men+'.')
    #self.mutex.release()

  # -----------------------------------------------------------------
  # INI CODIGO 'Buscar' ---------------------------------------------

  def buscar(self):
    entry=self.status.component('entry')
    self.cadBuscar = entry.get()
    if self.buscarTecla in ['Return','Return2'] and self.cadBuscar!="":
      newPos = self.prog.search(self.cadBuscar,self.buscarPos)
      if newPos!="":
        self.buscarPos=split(newPos,'.')[0]+'.'+str(int(split(newPos,'.')[1])+len(self.cadBuscar))
        self.prog.mark_set(INSERT, newPos)
        self.prog.see(INSERT)
        try:
          self.prog.tag_delete('BUSCAR')
          self.prog.tag_configure('BUSCAR',bg='blue')
        except: pass
        self.prog.tag_add('BUSCAR',newPos,self.buscarPos)
        self.prog.tag_config('BUSCAR',background='blue')
    if self.buscarTecla!='Return2':
      self.buscarPos=self.prog.index(INSERT)
      self.ponerBindingsProg()
      entry.grab_release()
      self.prog.focus_set()
      self.ponBarraMensajes('')
      try:  self.prog.tag_delete('BUSCAR')
      except: pass
    self.buscarTecla='INI'
  def ponBuscar(self):
    if self.nombre=='<python>': return
    if self.ejecucion=='on': return
    try: self.bMensaje.destroy()
    except: pass
    try: x=self.buscarPos
    except: self.buscarPos=self.prog.index(INSERT)
    self.buscarTecla='Return'
    self.quitarBindingsProg()
    self.status=Pmw.EntryField(self.msg2,command=self.buscar,
                               label_text=_('Buscar:'),labelpos=W)
    self.status.pack(side=LEFT,fill=X,expand=YES)
    entry=self.status.component('entry')
    entry.bind('<Control-s>', self.Buscar_teclaControl_s)
    entry.bind('<Control-S>', self.Buscar_teclaControl_s)
    entry.bind('<Escape>', self.BuscarIr_teclaEscape)
    entry.bind('<Tab>', self.NoHacerNada)
    entry.grab_set()
    entry.focus_set()

  # FIN CODIGO 'Buscar' ---------------------------------------------
  # -----------------------------------------------------------------

  # -----------------------------------------------------------------
  # INI CODIGO 'Ir a...' --------------------------------------------

  def irA(self):
    entry=self.status.component('entry')
    try: goto = int(entry.get())
    except: goto = 0
    if goto>0 and self.buscarTecla!='Escape':
      self.prog.mark_set(INSERT, str(goto)+'.0')
      self.prog.see(INSERT)
    self.ponerBindingsProg()
    entry.grab_release()
    self.prog.focus_set()
    self.ponBarraMensajes('')
  def ponIrA(self):
    if self.nombre=='<python>': return
    if self.ejecucion=='on': return
    try: self.bMensaje.destroy()
    except: pass
    try: x=self.buscarPos
    except: self.buscarPos=self.prog.index(INSERT)
    self.buscarTecla='Return'
    self.quitarBindingsProg()
    self.status = Pmw.EntryField(self.msg2,command=self.irA,
                               errorbackground='white',
                               validate='numeric',
                               label_text=_('Ir a lnea:'),labelpos=W)
    self.status.pack(side=LEFT,fill=X,expand=YES)
    entry=self.status.component('entry')
    entry.bind('<Escape>', self.BuscarIr_teclaEscape)
    entry.bind('<Tab>', self.NoHacerNada)
    entry.grab_set()
    entry.focus_set()

  # FIN CODIGO 'Ir a...' --------------------------------------------
  # -----------------------------------------------------------------

  # -----------------------------------------------------------------
  # INI CODIGO 'Reemplazar' -----------------------------------------

  def reemplazar(self):
    entry=self.status.component('entry')
    try: pal = entry.get()
    except: pal = ''
    if pal!='':
      esta = self.prog.search(pal,self.prog.index(INSERT),
                              stopindex=END)
    else: esta=''
    if pal!='' and self.buscarTecla!='Escape' and esta!='':
      self.reem_pal1=pal
      self.ponReemplazar2()
    else:
      self.ponerBindingsProg()
      entry.grab_release()
      self.prog.focus_set()
      if esta!='' or pal=='':
        self.ponBarraMensajes('')
      else:
        self.ponBarraMensajes(_('No se encontr ninguna ocurrencia a partir del cursor.'))
  def ponReemplazar(self):
    if self.nombre=='<python>': return
    if self.ejecucion=='on': return
    try: self.bMensaje.destroy()
    except: pass
    self.buscarTecla='Return'
    self.quitarBindingsProg()
    self.status=Pmw.EntryField(self.msg2,command=self.reemplazar,
                               label_text=_('Reemplazar:'),labelpos=W)
    self.status.pack(side=LEFT,fill=X,expand=YES)
    entry=self.status.component('entry')
    entry.bind('<Escape>', self.BuscarIr_teclaEscape)
    entry.bind('<Tab>', self.NoHacerNada)
    entry.grab_set()
    entry.focus_set()
  def reemplazar2(self):
    entry=self.status.component('entry')
    try: pal = entry.get()
    except: pal = None
    if pal!=None and self.buscarTecla!='Escape':
      self.reem_pal2=pal
      self.ponReemplazar3()
    else:
      self.ponerBindingsProg()
      entry.grab_release()
      self.prog.focus_set()
      self.ponBarraMensajes('')
  def ponReemplazar2(self):
    try: self.status.destroy()
    except: pass
    self.buscarTecla='Return'
    cadena=_('Reemplazar %s con:') % self.reem_pal1
    self.status=Pmw.EntryField(self.msg2,command=self.reemplazar2,
                               label_text=cadena,labelpos=W)
    self.status.pack(side=LEFT,fill=X,expand=YES)
    entry=self.status.component('entry')
    entry.bind('<Escape>', self.BuscarIr_teclaEscape)
    entry.bind('<Tab>', self.NoHacerNada)
    entry.grab_set()
    entry.focus_set()
  def Reem(self):
    entry=self.status.component('entry')
    cadBuscar = self.reem_pal1
    newPos = self.prog.search(cadBuscar,self.buscarPos,stopindex=END)
    if newPos!="":
      pos=split(newPos,'.')
      
      self.prog.mark_set(INSERT, newPos)
      self.prog.see(INSERT)
      try:  self.prog.tag_delete('BUSCAR')
      except: pass
      self.prog.tag_configure('BUSCAR',bg='blue')
      self.prog.tag_add('BUSCAR',newPos,
                        newPos+'+%dc' % (len(cadBuscar)))
      self.prog.tag_config('BUSCAR',background='blue')
      self.buscarTecla='INI'
      self.buscarPos=pos[0]+'.'+str(int(pos[1])+len(self.reem_pal2))
      return 1
    else:
      #entry.event_generate('<Return>')
      self.buscarTecla='INI'
      self.BuscarIr_teclaEscape()
      return 0
  def Reemplazar_tecla_s(self,event=None):
    try:
      self.prog.delete(INSERT,INSERT+'+%dc'%len(self.reem_pal1))
      self.numReem=self.numReem+1
      self.prog.insert(INSERT,self.reem_pal2)
      self.prog.see(INSERT)
      self.Reem()
    except: pass
    return "break"
  def Reemplazar_tecla_n(self,event=None):
    self.buscarPos+='+1c'
    self.Reem()
    return "break"
  def Reemplazar_tecla_t(self,event=None):
    ok=1
    while ok:
      try:
        self.prog.delete(INSERT,INSERT+'+%dc'%len(self.reem_pal1))
        self.numReem=self.numReem+1
        self.prog.insert(INSERT,self.reem_pal2)
        self.prog.see(INSERT)
        ok=self.Reem()
      except: return "break"
    return "break"
  def Reemplazar_salir(self):
    try:  self.prog.tag_delete('BUSCAR')
    except: pass
    entry=self.status.component('entry')
    self.ponerBindingsProg()
    entry.grab_release()
    self.prog.focus_set()
    if self.numReem==1:  men=_('Reemplazada 1 ocurrencia.')
    elif self.numReem>1: men=_('Reemplazadas %d ocurrencias.') % self.numReem
    else:                men=''
    self.ponBarraMensajes(men)
  def ponReemplazar3(self):
    try: self.status.destroy()
    except: pass
    self.numReem=0
    self.buscarPos=self.prog.index(INSERT)
    self.buscarTecla='Return'
    opciones=_('s/n/t')
    cadena=_('Reemplazar %s con %s [%s/Escape]:') % (self.reem_pal1,self.reem_pal2,opciones)
    self.status=Pmw.EntryField(self.msg2,command=self.Reemplazar_salir,
                               label_text=cadena,labelpos=W,
                               validate={'validator':'alphanumeric','max':0})
    #self.status=Label(self.msg,text=cadena,justify=LEFT)
    self.status.pack(side=LEFT,fill=X,expand=YES)
    entry=self.status.component('entry')
    entry.bind('<Escape>',  self.BuscarIr_teclaEscape)
    o_si=opciones[0]
    o_Si=o_si.upper()
    o_no=opciones[2]
    o_No=o_no.upper()
    o_todo=opciones[4]
    o_Todo=o_todo.upper()
    entry.bind('<Key-%s>'%o_si, self.Reemplazar_tecla_s)
    entry.bind('<Key-%s>'%o_Si, self.Reemplazar_tecla_s)
    entry.bind('<Key-%s>'%o_todo, self.Reemplazar_tecla_t)
    entry.bind('<Key-%s>'%o_Todo, self.Reemplazar_tecla_t)
    entry.bind('<Key-%s>'%o_no, self.Reemplazar_tecla_n)
    entry.bind('<Key-%s>'%o_No, self.Reemplazar_tecla_n)
    entry.bind('<Tab>', self.NoHacerNada)
    entry.grab_set()
    entry.focus_set()    
    self.Reem()
    
  # FIN CODIGO 'Reemplazar' -----------------------------------------
  # -----------------------------------------------------------------

  # -----------------------------------------------------------------
  # INI FUNCIONES PREDEFINIDAS DE PYTHONG ---------------------------

  def clear_output(self):
    self.progS.delete('1.0',END)
  # -------------------------------------------------
  def save_EPS(self,nombre):
    if self.abortar==2: return 0
    if self.abortar==1:
      self.abortar=2
      raise abortadoPorUsuario
    self.mutex.acquire() #--------
    data=self.canvas.postscript(pagey=430,pagex=297,
                                height=self.alto,width=self.ancho+2,x=-1,
                                pagewidth='20.0c')
    try:
      f=open(nombre,'w')
      try:     f.write(data)
      finally: f.close()
      res=1
    except:
      res=0
    if self.wum==1: self.mutex.notify()
    self.mutex.release() #--------
    return res
  # -----------------------------------------------------------------  
  def window_style(self,tit,colorFondo='white',soloGraf='TODO'):
    #los otros parmetros no se utilizan en PythonG
    self.canvas.configure(background=colorFondo)
  # -----------------------------------------------------------------  
  def newWorkSpace(self):
    self.mutex.acquire() #--------
    for i in self.workspace.children.values(): i.destroy()
    if self.wum==1: self.mutex.notify()
    self.mutex.release() #--------
    return self.workspace
  # -----------------------------------------------------------------
  def window_size(self,ancho=None,alto=None):
    if self.abortar==2: return 
    if self.abortar==1:
      self.abortar=2
      raise AbortadoPorUsuario
    if ancho==None or alto==None: return [self.ancho,self.alto]
    self.ancho, self.alto = ancho, alto
    self.escala_x = (self.ancho-1) / float(self.xsup-self.xinf)
    self.escala_y = (self.alto-1)  / float(self.ysup-self.yinf)

    self.mutex.acquire() #--------
    try:
      map(self.canvas.delete,self.canvas.find_all())
      self.canvas.configure(width=self.ancho,height=self.alto)
    except TclError: pass
    if self.wum==1: self.mutex.notify()
    self.mutex.release() #--------
  # -----------------------------------------------------------------    
  def window_coordinates(self,xinf=None,yinf=None,
                         xsup=None,ysup=None):
    if self.abortar==2: return 
    if self.abortar==1:
      self.abortar=2
      raise AbortadoPorUsuario
    if xinf==None or yinf==None or xsup==None or ysup==None:
      return [self.xinf,self.yinf,self.xsup,self.ysup]
    self.xinf,self.yinf,self.xsup,self.ysup = xinf,yinf,xsup,ysup
    self.escala_x = (self.ancho-1) / float(self.xsup-self.xinf)
    self.escala_y = (self.alto-1)  / float(self.ysup-self.yinf)

    self.mutex.acquire() #--------
    try:
      map(self.canvas.delete,self.canvas.find_all())
    except TclError: pass
    if self.wum==1: self.mutex.notify()
    self.mutex.release() #--------
  # -----------------------------------------------------------------
  def create_text(self,x,y,cadena,tam=10,ancla='CENTER',color='black',**args):
    if self.abortar==2: return 
    if self.abortar==1:
      self.abortar=2
      raise AbortadoPorUsuario
    args['text']=cadena
    args['anchor']=posAncla[ancla]
    args['fill']=color
    if posix: args['font']=('courier',tam,'bold')
    else:     args['font']=('courier',int(tam*1.15+2),'bold')
    try:
      xb = (x-self.xinf) * self.escala_x 
      yb = self.alto - 1 - (y- self.yinf) * self.escala_y
    except:
      raise CoordenadasErroneas,(x,y)
    self.mutex.acquire() #--------
    try:
      aux = self.canvas.create_text(xb, yb, args)
    except:
      self.mutex.release() #--------
      raise ErrorEnParametro('create_text', (x,y,cadena,ancla))
    if self.wum==1: self.mutex.notify()
    self.mutex.release() #--------
    return aux
  # -----------------------------------------------------------------
  def move(self,tags,x,y):
    if self.abortar==2: return 0
    if self.abortar==1:
      self.abortar=2
      raise AbortadoPorUsuario
    try:
      xb = x*self.escala_x 
      yb = -y*self.escala_y
    except:
      raise CoordenadasErroneas, (x,y)
    self.mutex.acquire() #--------
    try: self.canvas.move(tags,xb,yb)
    except:
      self.mutex.release() #--------
      raise ErrorEnParametro('move', (tags,x,y))
    if self.wum==1: self.mutex.notify()
    self.mutex.release() #--------
  # -----------------------------------------------------------------
  def create_line(self,x1,y1,x2,y2,color='black',**args):
    if self.abortar==2: return 0
    if self.abortar==1:
      self.abortar=2
      raise AbortadoPorUsuario
    args['fill']=color
    try:
      x1b = (x1-self.xinf) * self.escala_x 
      y1b = self.alto - 1 - (y1- self.yinf) * self.escala_y
      x2b = (x2-self.xinf) * self.escala_x
      y2b = self.alto - 1 - (y2-self.yinf) * self.escala_y
    except:
      raise CoordenadasErroneas, (x1,y1,x2,y2)
    self.mutex.acquire() #--------
    try:
      aux = self.canvas.create_line(x1b, y1b, x2b, y2b, args)
    except:
      self.mutex.release() #--------
      raise ErrorEnParamtero('create_line', (x1,y1,x2,y2,color))
    if self.wum==1: self.mutex.notify()
    self.mutex.release() #--------
    return aux
  # -----------------------------------------------------------------
  def create_filled_rectangle(self,x1,y1,x2,y2,color='black',
                              relleno=None,**args):
    if relleno==None: relleno=color
    return self.create_rectangle(x1,y1,x2,y2,color,relleno,**args)
  # -----------------------------------------------------------------
  def create_rectangle(self,x1,y1,x2,y2,color='black',relleno=None,**args):
    if self.abortar==2: return 0
    if self.abortar==1:
      self.abortar=2
      raise AbortadoPorUsuario
    args['outline']=color
    if relleno!=None: args['fill']=relleno
    try:
      x1b = (x1-self.xinf) * self.escala_x 
      y1b = self.alto - 1 - (y1- self.yinf) * self.escala_y
      x2b = (x2-self.xinf) * self.escala_x
      y2b = self.alto - 1 - (y2-self.yinf) * self.escala_y
    except:
      raise CoordenadasErroneas, (x1,y1,x2,y2)
    self.mutex.acquire() #--------
    try:
      aux = self.canvas.create_rectangle(x1b, y1b, x2b, y2b, args)
    except:
      self.mutex.release() #--------
      if relleno!=None:
        raise ErrorEnParametro('create_filled_rectangle', (x1,y1,x2,y2,color,relleno))
      else:
        raise ErrorEnParametro('create_rectangle', (x1,y1,x2,y2,color))
    if self.wum==1: self.mutex.notify()
    self.mutex.release() #--------
    return aux
  # -----------------------------------------------------------------
  def create_filled_circle(self,x,y,radio,color='black',relleno=None,**args):
    if relleno==None: relleno=color
    return self.create_circle(x,y,radio,color,relleno,**args)
  # -----------------------------------------------------------------
  def create_circle(self,x,y,radio,color='black',relleno=None,**args):
    if self.abortar==2: return 0
    if self.abortar==1:
      self.abortar=2
      raise AbortadoPorUsuario
    args['outline']=color
    if relleno!=None: args['fill']=relleno
    try:
      x1b=(x-self.xinf-radio)* self.escala_x
      x2b=(x-self.xinf+radio)* self.escala_x
      y1b=self.alto - 1 - (y-self.yinf-radio)* self.escala_y
      y2b=self.alto - 1 - (y-self.yinf+radio)* self.escala_y
    except:
      raise CoordenadasErroneas, (x,y)
    self.mutex.acquire() #--------
    try:
      aux = self.canvas.create_oval(x1b, y1b, x2b, y2b, args)
    except:
      self.mutex.release() #--------
      if relleno!='no':
        raise ErrorEnParametro('create_filled_circle', (x,y,radio,color,relleno))
      else:
        raise ErrorEnParametro('create_circle', (x,y,radio,color))
    if self.wum==1: self.mutex.notify()
    self.mutex.release() #--------
    return aux
  # -----------------------------------------------------------------
  def window_update(self):
    if self.abortar==2: return 0
    if self.abortar==1:
      self.abortar=2
      raise AbortadoPorUsuario
    self.mutex.acquire() #--------
    self.mutex.notify()#self.canvas.update()
    self.mutex.release() #--------
  # -----------------------------------------------------------------
  def set_window_update_mode(self,modo):
    self.wum=modo
  # -----------------------------------------------------------------
  def execmutex(self,cad):
    self.mutex.acquire() #--------
    self.mostrarMensaje('VAMOS')
    self.raiz.update()
    try: exec cad
    except:
      self.mostrarMensaje('NO OK')
      self.mutex.release() #--------
      raise MiError, "kkk"
    self.mostrarMensaje('OK')
    if self.wum==1: self.mutex.notify()
    self.mutex.release() #--------
  # -----------------------------------------------------------------
  def create_point(self,x,y,color='black',**args):
    if self.abortar==2: return 0
    if self.abortar==1:
      self.abortar=2
      raise AbortadoPorUsuario
    args['fill']=color
    args['width']=2
    try:
      x1b=(x-self.xinf)*self.escala_x - 0.5
      x2b=x1b+2
      y1b=self.alto - 1 - (y-self.yinf)*self.escala_y
    except:
      raise CoordenadasErroneas, (x,y)
    self.mutex.acquire() #--------
    try:
      aux = self.canvas.create_line(x1b, y1b, x2b, y1b,args)
    except:
      self.mutex.release() #--------
      raise ErrorEnParametro('create_point', (x,y,color))
    if self.wum==1: self.mutex.notify()
    self.mutex.release() #--------
    return aux
  # -----------------------------------------------------------------  
  def erase(self,indice=None):
    if self.abortar==2: return
    if self.abortar==1:
      self.abortar=2
      raise AbortadoPorUsuario
    self.mutex.acquire() #--------
    if indice==None:
      try: map(self.canvas.delete,self.canvas.find_all())
      except TclError: pass
    else:
      try:
        self.canvas.delete(indice)
      except:
        self.mutex.release() #--------
        raise ErrorIndiceBorrado, indice
    if self.wum==1: self.mutex.notify()
    self.mutex.release() #--------
  # -----------------------------------------------------------------
  def mouse_state(self):
    if self.abortar==2: return
    if self.abortar==1:
      self.abortar=2
      raise AbortadoPorUsuario
    return self.ultimoEstadoRaton
  # -----------------------------------------------------------------
  def keypressed(self,retardo=2):
    # 0: No espera, con retardo de repeticion
    # 1: No espera, sin retardo de repeticion (juegos)
    # 2: Espera a que se pulse una tecla, si ya estaba pulsada,
    #    espera a que se suelte antes de leer la correcta.
    if self.abortar==2: return
    if self.abortar==1:
      self.abortar=2
      raise AbortadoPorUsuario

    self.mutex.acquire() #--------
    self.progS.grab_set()
    if retardo==2:
      #self.progS.see(INSERT)
      while self.abortar==0 and len(self.bufTeclado)==0:
        self.mutex.release() #--------
        try: sleep(0.1)
        except: pass
        self.mutex.acquire() #--------
        #try:
        #  if self.cambioSG!=self.ocultarSG.get():
        #    if self.ocultarSG.get()=='1': self.workspace.pack_forget()
        #    else: self.workspace.pack(side=TOP,expand=NO)
        #except: pass
        #self.cambioSG=self.ocultarSG.get()
        #self.raiz.update()
    try:
      x = self.bufTeclado[0]
      self.bufTeclado =  self.bufTeclado[1:]
      self.progS.grab_release()
      self.mutex.release() #--------
      return x
    except:
      self.progS.grab_release()
      self.mutex.release() #--------
      if self.teclaApretada==1:
        if retardo==0: return None
        return self.ultimaTecla
      return None
    
  # FIN FUNCIONES PREDEFINIDAS DE PYTHONG ---------------------------
  # -----------------------------------------------------------------

  # -----------------------------------------------------------------
  # INI Controla semforo compartido con el thread de ejecucin  ----
  
  # -Esta funcin se ejecuta continuamente utilizando un after.
  # -Gestiona los errores de ejecucin.
  # -Libera el semforo unos instantes en cada llamada para que el
  #  thread de ejecucin pueda acceder al Tcl/Tk.
  def miUpdate(self):
    try:
      if self.cambioSG!=self.ocultarSG.get():
        if self.ocultarSG.get()=='1': self.workspace.pack_forget()
        else: self.workspace.pack(side=TOP,expand=NO,pady=4)
    except: pass
    self.cambioSG=self.ocultarSG.get()
    
    if self.ejecucion!='on':
      try:
        if self.cambioOcultarSalidas!=self.ocultarSalidas.get():
          if self.ocultarSalidas.get()=='0':
            self.paned.configurepane('derecha',max=self.tamFuenteD,min=self.tamFuenteD)
            self.paned.configurepane('derecha',max=100000,min=0)
          else:
            self.tamFuenteD=self.tamDer
            self.paned.configurepane('derecha',max=0)
      except: pass
      self.cambioOcultarSalidas=self.ocultarSalidas.get()

    linea=split(self.prog.index(INSERT),'.')
    self.linea.set(linea[0])

    self.raiz.after(100, self.miUpdate)
    
  # FIN Controla semforo compartido con el thread de ejecucin  ----
  # -----------------------------------------------------------------
     
  def eventoRatonMovido(self, event, boton=0):
    if self.ejecucion!='on': return "break"
    x = event.x/self.escala_x-self.xinf
    y = self.yinf - (event.y-self.alto+1)/self.escala_y
    #sys.__stderr__.write("(%d %d) (%d %d)\n" % (event.x,event.y,x,y))
    self.ultimoEstadoRaton=(boton,x,y)
    return "break"
  def eventoRatonMovidoB1(self, event):
    if self.ejecucion!='on': return "break"
    return self.eventoRatonMovido(event,1)
  def eventoRatonMovidoB2(self, event):
    if self.ejecucion!='on': return "break"
    return self.eventoRatonMovido(event,2)
  def eventoRatonMovidoB3(self, event):
    if self.ejecucion!='on': return "break"
    return self.eventoRatonMovido(event,3)
  def eventoRatonFuera(self,event):
    if self.ejecucion!='on': return "break"
    self.ultimoEstadoRaton=(None,None,None)
  def eventoBotonPulsado(self,boton,event):
    x = event.x/self.escala_x-self.xinf
    y = self.yinf - (event.y-self.alto+1)/self.escala_y
    self.ultimoEstadoRaton=(boton,x,y)
    return "break"
  def eventoBotonSoltado(self, event):
    self.ultimoEstadoRaton=(0,self.ultimoEstadoRaton[1],self.ultimoEstadoRaton[2])
    if self.ejecucion!='on': return "break"
  def eventoBoton1Pulsado(self, event):
    if self.ejecucion!='on': return "break"
    return self.eventoBotonPulsado(1,event)
  def eventoBoton2Pulsado(self, event):
    if self.ejecucion!='on': return "break"
    return self.eventoBotonPulsado(2,event)
  def eventoBoton3Pulsado(self, event):
    if self.ejecucion!='on': return "break"
    return self.eventoBotonPulsado(3,event)
                         
  # -----------------------------------------------------------------
  def eventoTeclaPulsada(self, event):
    #event.char esta en 'utf8'
    if self.ejecucion!='on': return "break"
    global lineaTeclado, entradaFormal
    if event.char=='\x03': return #Control-C
    try:
      imprimible=ord(event.char)>127 or (event.char in string.printable)
    except TypeError: #para caracteres no de 8 bits 
      imprimible=1
      
    try: unicode(event.char,'utf8').encode(codigoChar)
    except: imprimible=0
    
    if entradaFormal==1:
      if event.keysym=='Return' or event.char=='\x04':
        if event.char=='\x04': #Control-D
          x=join(lineaTeclado,'')+'\x04'+'\n'
        else:
          x=join(lineaTeclado,'')+'\n'
          self.progS.insert(END,'\n')
        #try: x2=unicode(x,'utf8').encode(codigoChar)
        #except: x2=x
        x2=x.encode('utf8')
        self.inp.write(x2)
        lineaTeclado=[]
      elif event.keysym=='BackSpace':
        if len(lineaTeclado)>0:
            lineaTeclado =lineaTeclado[:-1]
            self.progS.delete(END+'-2c',END)
      elif event.char!='' and imprimible: # and event.char in string.printable:
        if type(event.char)==type(u''):
          lineaTeclado.append(event.char)
          uniChar=event.char.encode('utf8')
          #sys.__stderr__.write(`event.char`+' '+`uniChar`+'\n')
          self.progS.insert(END,uniChar)
        else:
          lineaTeclado.append(unicode(event.char,'utf8'))
          self.progS.insert(END,event.char)
      self.progS.see(INSERT)
    else:
      self.ultimaTecla=event.keysym
      self.bufTeclado=[event.keysym]
      #self.bufTeclado.append(event.keysym)
      #if len(self.bufTeclado)>20: self.bufTeclado=self.bufTeclado[-10:]
    self.teclaApretada=1
    if event.char!='':
      self.tPrevia=None
      self.posC=split(self.prog.index(INSERT),'.')
    return "break"

  def eventoTeclaSoltada(self, event):
    if self.ejecucion!='on': return "break"
    self.teclaApretada=0
    
  def NoHacerNada(self,event=None): return "break"
  
  def ponerModoEjecucion(self):
    self.progS.delete('1.0',END)
    (self.r,self.w)=os.pipe()
    self.inp=os.fdopen(self.w,"w",0)
    self.out=os.fdopen(self.r,"r",0)
    sys.stdin=Input(self.out)
    sys.stdout=Output()
    sys.stderr=Output()
    self.workspace.focus_set()
    for i in self.workspace.children.keys():
      if i != self.idcanvas[0]:
        self.workspace.children[i].destroy()
    self.notebook.tab("<python>").bind('<ButtonPress>',self.NoHacerNada)
    self.menu.disableall()
    self.python.configure(state=NORMAL)
    self.bufTeclado = []
    self.progS.unbind('<FocusIn>')
    #self.progS.bind('<ButtonPress>', self.focoProgS)
    self.progS.focus_set()

  def focoProgS(self,event=None):
    self.progS.focus_set()
    return "break"
    
  def quitarModoEjecucion(self):
    sys.stderr=self.aux_stderr
    sys.stdout=self.aux_stdout
    sys.stdin=self.aux_stdin
    self.inp.close()
    self.out.close()
    self.notebook.tab("<python>").unbind('<ButtonPress>')
    self.menu.enableall()
    self.progS.bind('<FocusIn>', self._focoProg)
    self.prog.focus_set()
    #self.progS.unbind('<ButtonPress>')

  def ponerModoDepuracion(self):
    self.progS.delete('1.0',END)
    (self.r,self.w)=os.pipe()
    self.inp=os.fdopen(self.w,"w",0)
    self.out=os.fdopen(self.r,"r",0)
    sys.stdin=Input(self.out)
    sys.stdout=Output()
    sys.stderr=Output()
    self.workspace.focus_set()
    for i in self.workspace.children.keys():
      if i != self.idcanvas[0]:
        self.workspace.children[i].destroy()
    self.notebook.tab("<python>").bind('<ButtonPress>',self.NoHacerNada)
    self.menu.disableall()
    m=[(_('Depurar'), '', 
        ((_('Paso')+' (F7)', self.dep.step),
         (_('Siguiente')+' (F8)', self.dep.next),
         (_('Return')+' (F5)', self.dep.ret),
         (_('Continua')+' (F9)', self.dep.cont),
         (_('Ir a cursor')+' (F4)', self.dep.irA),
         #('', ''),
         #('Poner breakpoint', lambda s=self: s.mostrarMensajeError(_('No implementado'))),
         #('Quitar breakpoint', lambda s=self: s.mostrarMensajeError(_('No implementado'))),
         ('', ''),
         (_('Salir modo depuracin')+' (Esc)', self.dep.quit)))]
    self.ponMenu(m)
    self.bufTeclado = []
    self.prog.focus_set()

  def quitarModoDepuracion(self):
    sys.stderr=self.aux_stderr
    sys.stdout=self.aux_stdout
    sys.stdin=self.aux_stdin
    self.inp.close()
    self.out.close()
    self.menu.deletemenu(_('Depurar'))
    self.notebook.tab("<python>").unbind('<ButtonPress>')
    self.menu.enableall()

  def ponRuta(self,ruta):
    r=ruta
    if sys.platform[:3]=='win': barra='\\'
    else: barra='/'
    try:
     if ruta[-1]!=barra: r+=barra
    except: r=barra
    self.nombreRuta.set(r)
    
  # -----------------------------------------------------------------
  # INI funciones que se llaman desde los menus

  def nuevoFichero(self,event=None):
    self.nuevaPestanya('<'+_('annimo')+'>',None)
    self.mostrarMensaje(_("Fichero nuevo"))

  def cerrarFichero(self,event=None):
    nom=self.notebook.getcurselection()
    nom=nom.replace(marca,'_')
    if nom=='<python>': 
      self.mostrarMensajeError(_('En PythonG no es posible cerrar la pestaa del intrprete'))
      return
    data=self.prog.get('1.0',END+'-1c')
    if data!=self.listaProg[nom].data:
      cerrar = askyesno(_("AVISO"),
                        _("Programa '%s' no guardado, desea cerrar la pestaa de todas formas?")
                        % (nom), default="no")
      #sys.__stderr__.write('XXX '+nom.encode('latin-1')+'\n')
      #sys.__stderr__.write('XXX '+`cerrar`+'\n')
      if cerrar:
        self.borrarPestanya(nom)
    else:
      self.borrarPestanya(nom)
      
  def abrirFichero(self,event=None,preguntar=1):
    nom=self.nombre
    if preguntar==1:
      if posix:
        ftypes=[(_('Programas python'),'*.py'),
                (_('Todos los ficheros'),'*')]
      else:
        ftypes=[(_('Programas python (.py y .pyw)'),'*.py*'),
                (_('Programas python con consola'),'*.py'),
                (_('Programas python sin consola'),'*.pyw'),
                (_('Todos los ficheros'),'*')]
      nom=tkFileDialog.askopenfilename(title=_("Abrir"), parent=self.raiz,
                                       filetypes=ftypes)
    if nom:
      nom=os.path.normcase(os.path.abspath(nom))
      #sys.__stderr__.write('---- '+`nom`+'\n')
      #try: map(self.canvas.delete,self.canvas.find_all()) 
      #except TclError: pass
      try:
        f=codecs.open(nom,'r',codigoChar)
        try:     dataOrig=f.read() #dataOrig es unicode
        finally: f.close()
        data=replace(dataOrig,'\t','  ')
        if data!=dataOrig:
          ruta, nomFich = os.path.split(nom) # ponia self.nombre 
          c = tkMessageBox.askokcancel(
            _("AVISO"),
            _("El fichero '%s' contiene tabuladores.\n Si continuas, se sustituir cada uno de ellos por dos caracteres espacio, lo que puede resultar en un programa Python incorrecto.\n Cargar el fichero igualmente?") % (nomFich), default="ok")
          #sys.__stderr__.write('XXX '+`c`+'\n')
          if not c: return
        dataCopia=data[:]
        convReturn=0
        #cambia '\r\n' o '\r' por '\n'
        dataCopia=convierte_saltos_de_linea(dataCopia)
        if data!=dataCopia: convReturn=1
        data=dataCopia
        #try: data=unicode(data, codigoChar) #XXX
        #except: pass
      except IOError:
        data=None
      self.nuevaPestanya(nom,data)
      if data==None:
        self.mostrarMensaje(_('Fichero nuevo (no se pudo leer el fichero solicitado)'))
      elif convReturn:
        self.mostrarMensaje(_('Fichero cargado [Efectuados cambios en los saltos de lnea]'))
      else:
        self.mostrarMensaje(_('Fichero cargado'))
      
  def salvarSalidaGraficaComo(self):
    nombre=tkFileDialog.asksaveasfilename(\
        title=_("Guardar salida grfica como"), parent=self.raiz, initialfile='',
        filetypes=[(_('Fichero postscript encapsulado'),'*.eps')])
    if not nombre: return
    data=self.canvas.postscript(pagey=430,pagex=297,
                                height=self.alto,width=self.ancho+2,x=-1,
                                pagewidth='20.0c')
    try:
      f=open(nombre,'w')
      try:     f.write(data)
      finally: f.close()
      self.mostrarMensaje(_('Fichero guardado'))
    except:
      self.mostrarMensajeError(_('No se pudo guardar el fichero'))
      
  def salvarTextoComo(self,ventana):
    nombre=tkFileDialog.asksaveasfilename(\
        title=_("Guardar salida de texto como"), parent=self.raiz, initialfile='',
        filetypes=[(_('Fichero de texto'),'*.txt')])
    if not nombre: return
    dataP=ventana.get('1.0',END+'-1c')
    # asegura que data sea unicode
    try: data=dataP.decode(codigoChar)
    except: data=dataP
    try:
      f=codecs.open(nombre,'w',codigoChar)
      try:     f.write(data)
      finally: f.close()
      self.mostrarMensaje(_('Fichero guardado'))
    except:
      self.mostrarMensajeError(_('No se pudo guardar el fichero'))
      
  def salvarFicheroComo(self,event=None,preguntar=1):
    from glob import glob
    if self.nombre=='<python>': return self.salvarTextoComo(self.prog)
    rutaOriginal, nomFichOriginal = os.path.split(self.nombre)
    nombreOriginal=self.nombre
    if preguntar==1 or self.nombre[0]=='<':
      if self.nombre=='<'+_('annimo')+'>':
        numF=-1
        for nx in glob(_('programa')+'-*.py'):
          try: numFP=int(nx.replace(_('programa')+'-','').replace('.py',''))
          except: break
          numF=max(numF,numFP)
        nom=_('programa')+'-%02d.py'%(numF+1)
      else:
        ruta, nom = os.path.split(self.nombre)
      self.nombre=tkFileDialog.asksaveasfilename(\
        title=_("Guardar '%s' como")%nomFichOriginal, parent=self.raiz, initialfile=nom,
        filetypes=[(_('Programas python'),'*.py'),(_('Todos los ficheros'),'*')])
      if not self.nombre:
        self.nombre=nombreOriginal
        return -1
    self.nombre=os.path.normcase(os.path.abspath(self.nombre))
    dataP=self.prog.get('1.0',END+'-1c')
    # asegura que data sea unicode
    try: data=dataP.decode(codigoChar)
    except: data=dataP
    self.listaProg[nomFichOriginal].data=data[:]
    try:
      ruta, nomFich = os.path.split(self.nombre)
      if self.listaProg.has_key(nomFich) and nomFichOriginal!=nomFich:
        tkMessageBox.showerror(_('Error'),
                               _("No se pudo guardar el fichero: el nombre propuesto (%s) coincide con el de otra pestaa. Cirrala y vuelve a intentarlo.") % nomFich)
        self.nombre=nombreOriginal
        return -1
      #f=codecs.open(self.nombre,'w',codigoChar)
      f=open(self.nombre,'w')
      try:     f.write(data.encode(codigoChar))
      finally: f.close()
      
      self.ponRuta(ruta)
      self.mostrarMensaje(_('Fichero guardado'))
      if self.nombre != nombreOriginal:
        nom=self.nombre
        ind=self.notebook.index(Pmw.SELECT)
        self.borrarPestanya(nomFichOriginal)
        self.nuevaPestanya(nom,data,ind)
    except:
      #sys.stdout=sys.__stderr__
      #sys.stderr=sys.__stderr__
      #traceback.print_exc()
      self.mostrarMensajeError(_('No se pudo guardar el fichero'))
      return -1
      
  def ejecutar(self,event=None,dep=0):
    if self.abortar==2: return
    if self.ejecucion != 'off':
      self.abortar=1
      if entradaFormal==1: self.inp.write('\n')
      return
    if dep==1:
      listaG=[]
      for aux in self.listaProg.values():
        if aux.nombre=='<python>': continue
        if aux.nombre=='<'+_('annimo')+'>':
          listaG.append(aux)
        else:
          data=aux.pestanya.get('1.0',END+'-1c')
          if data != aux.data: listaG.append(aux)
      if len(listaG)>0:
        continuar = askyesno(_("AVISO"),
           _("Antes de pasar a modo depuracin se guardarn todas las pestaas modificadas, guardar y continuar?"),
                                        default="yes")
        if not continuar: return

        pestanya_actual=self.nombre
        for aux in listaG:
          ruta, nom = os.path.split(aux.nombre)
          self.nombre=aux.nombre
          self.notebook.selectpage(nom.replace('_',marca))
          if self.salvarFicheroComo(None,0)==-1:
            self.mostrarMensajeError(_('No se activar el modo depuracin al no haberse guardado todas las pestaas modificadas'))
            return
          if aux.nombre==pestanya_actual: pestanya_actual=self.nombre

        self.nombre=pestanya_actual
        ruta, nom = os.path.split(self.nombre)
        self.notebook.selectpage(nom.replace('_',marca))

    self.ejecucion='on'
    self.quitarBindingsProg()
    self.insdelprog='off'
    #ini paneles
    if self.ocultarSalidas.get()=='1':
      self.paned.configurepane('derecha',max=self.tamFuenteD,min=self.tamFuenteD)
      self.paned.configurepane('derecha',max=100000,min=0)
    if self.ocultarFuentes.get()=='1':
      self.tamFuenteI=self.tamIzq
      self.paned.configurepane('izquierda', max=0)
    #fin paneles
    self.ancho, self.alto = anchoOrig[grSizeDefecto], altoOrig[grSizeDefecto]
    self.xinf,self.yinf,self.xsup,self.ysup=0,0,tamMundoOrig,tamMundoOrig
    self.window_size(self.ancho,self.alto)
    self.window_coordinates(self.xinf,self.yinf,self.xsup,self.ysup)
    try: map(self.canvas.delete,self.canvas.find_all())
    except TclError: pass
    x=self.prog.get('1.0',END)#+'-1c')
    try: self.codigo=x.encode(codigoChar) #,'replace')  #XXX
    except: self.codigo=x
    if dep==0:
      self.ponerModoEjecucion()
      tPython = MyThread()
      self.mostrarMensaje(_('Ejecutando... (Ctrl-C Ctrl-C para abortar)'))
    else:
      from pythongdeb import Depurador
      self.dep=Depurador(ventana)
      self.ponerModoDepuracion()
      tPython = MyThreadDebug()
      self.mostrarMensaje(_('Depurando... (Ctrl-C Ctrl-C para abortar)'))
    self.teclaApretada=0
    self.ultimoEstadoRaton=(None,None,None)
    self.bufB=[]
    self.tPrevia=""
    #self.mostrarMensajeError(u'KKK1')
    self.mutex.acquire()
    self.hacerPaso=0
    self.wum=0
    self.raiz.update()
    self.xxx=self.canvas.update
    self.canvas.update=lambda: None
    tPython.start()
    while self.ejecucion=='on':
      while self.hacerPaso==0 and self.ejecucion=='on':
        self.mutex.wait(0.05)
        self.mutex.acquire()
        #self.raiz.update()
        self.xxx() 
      if self.ejecucion!='on': break
      self.dep.pre_interaction()
      self.raiz.mainloop()
      while self.hacerPaso==1:
        try: sleep(0.05)
        except: pass
    self.wum=0
    self.canvas.update=self.xxx
    self.canvas.update()
    self.raiz.update()
    self.mutex.release()
    
    #self.mostrarMensajeError(u'KKK5')
    #self.post_eje()
    #ini paneles
    if self.ocultarFuentes.get()=='1':
      self.paned.configurepane('izquierda',max=self.tamFuenteI,min=self.tamFuenteI)
      self.paned.configurepane('izquierda',max=100000,min=0)
    if self.ocultarSalidas.get()=='1':
      self.tamFuenteD=self.tamDer
      self.paned.configurepane('derecha',max=0)
    #fin paneles
    #self.progS.grab_release()
    if dep==0:
      self.quitarModoEjecucion()
    else:
      self.quitarModoDepuracion()
      self.depuracion='off'
      ventana.dep.close()
    self.post_eje()
    self.abortar=0
    self.ejecucion='off'
    self.insdelprog='on'
    self.ponerBindingsProg()
    if self.quererSalir: self.salir()
    
  def depurar(self,event=None):
    self.ejecutar(None,1)
      
  def post_eje(self):
    global mensajeError
    if self.ejecucion=='err1':
      self.mostrarMensaje(_("Abortado por el usuario"))
    elif self.ejecucion=='err2':
      self.mostrarMensaje(_('Error: durante ejecucin'))
      lin=''
      fichError=''
      aux1=split(mensajeError,'\n')
      for aux2 in aux1:
        aux2=replace(aux2,',',' ')
        aux2=replace(aux2,';',' ')
        aux3=split(aux2)
        cambiar=0
        for pos in range(len(aux3)):
          if aux3[pos]=='File' and pos<len(aux3)-1:
            x=aux2.split('"')[1]
            ruta, x = os.path.split(x)
            if x=='<string>' or self.listaProg.has_key(x):
              fichError=x
              cambiar=1
          if aux3[pos]=='line' and pos<len(aux3)-1:
            if cambiar: lin=aux3[pos+1]
            break
        #if lin!='': break
        #print lin,aux3
      #print "--",lin
      ruta, nomFich = os.path.split(self.nombre)
      #sys.__stderr__.write(fichError+'\n')
      #sys.__stderr__.write(`nomFich`+'\n')
      mensajeError=replace(mensajeError, '"<string>"',
                           '"'+nomFich+'"')
      d = MostrarError(self.raiz, mensajeError)
      if lin!='':
        if fichError not in ['','<string>']:
          self.notebook.selectpage(fichError.replace('_',marca))
        self.prog.mark_set(INSERT,lin+'.end')
        self.prog.see(lin+'.0')
        self.raiz.update()
        self.prog.see(INSERT)
        #self.prog.tag_add('sel', lin+'.0',lin+'.end')
    elif self.ejecucion=='ok':
      self.mostrarMensaje(_('Ejecucin completada'))

  def salir(self,event=None):
    guardarConfiguracion()
    for aux in self.listaProg.values():
      if aux.nombre=='<python>': continue
      data=aux.pestanya.get('1.0',END+'-1c')
      if data != aux.data:
        ruta, nom = os.path.split(aux.nombre)
        self.nombre=aux.nombre
        self.notebook.selectpage(nom.replace('_',marca))
        guardar = askyesno(_("AVISO"),
          _("Programa '%s' no guardado. Desea guardarlo antes de salir?") % nom,
          default="yes")
        if guardar: self.salvarFicheroComo(None,0)
    for aux in self.listaProg.values():
      if aux.nombre!='<python>':
        aux.undo.close()
        aux.undo=None
        aux.col.close()
        aux.col=None
        aux.p.close()
        aux.p=None
    if posix and self.ejecucion!='off':
      from signal import SIGKILL
      os.kill(os.getpid(),SIGKILL)
    self.raiz.quit()

  # Muestra el cuadro de dilogo 'Acerca de...'
  def acercaDe(self):
    Pmw.aboutversion(VERSION+u' (beta)')
    Pmw.aboutcopyright(u'Copyright Universitat Jaume I de Castell 2002-2003\n'
                       u'GNU GENERAL PUBLIC LICENSE (Version 2)')
    Pmw.aboutcontact(u'David Llorens (dllorens@lsi.uji.es)\n'
                     u'Dpt. Llenguatges i Sistemes Informtics\n'
                     u'Universitat Jaume I de Castell\n\n'+
                     _("Este programa utiliza segmentos de cdigo del programa 'idle v.0.5' de\nGuido van Rossum, que se distribuye bajo la licencia PSF (compatible GPL)"))
    Pmw.AboutDialog(self.raiz,title=_('Acerca de PythonG...'), applicationname=
                    'PythonG (http://www3.uji.es/~dllorens/PythonG/)')
    
  # Oculta/muestra la ventana grfica
  def mostrarOcultarSG(self):
    global conf
    if self.ocultarSG.get()=='0': self.ocultarSG.set('1')
    else: self.ocultarSG.set('0')
  
  #se llama de cerrarFichero y salvarFicheroComo
  def borrarPestanya(self,n):
    if not self.listaProg.has_key(n): 
      self.mostrarMensajeError(_('Ninguna pestaa tiene ese nombre'))
      return
    aux=self.listaProg[n]
    if aux.nombre=='<python>': return # no tendra que llegar aqu
    aux.undo.close()
    aux.undo=None
    aux.col.close()
    aux.col=None
    aux.p.close()
    aux.p=None
    self.notebook.delete(n.replace('_',marca))
    del self.listaProg[n]
  
  #se llama de nuevoFichero, abrirFichero y salvarFicheroComo
  def nuevaPestanya(self,nomFich,data,ind=None):
    ruta, n = os.path.split(nomFich)
    if self.listaProg.has_key(n): 
      self.mostrarMensajeError(_('No se pudo cargar el fichero: existe una pestaa con ese mismo nombre (%s). Cirrala y vuelve a intentarlo') % n)
      return
    if len(self.listaProg)>=10:
      self.mostrarMensajeError(_('Como mximo puedes tener 10 pestaas'))
      return
      
    self.prog = self.anyadirProgFuente(n,ind)
    aux=self.listaProg[n]=claseVacia()
    aux.pestanya=self.prog
    aux.nombre=nomFich
    self.nombre=nomFich
    if aux.nombre!='<python>':
      aux.p = Percolator(self.prog,ventana)
      aux.col = ColorDelegator(self.tagdefs)
      aux.undo = UndoDelegator(codigoChar)
      aux.p.insertfilter(aux.col)
      aux.p.insertfilter(aux.undo)
    if data!=None: self.prog.insert(END,data)
    if aux.nombre!='<python>': aux.undo.reset_undo()
    self.data=aux.data=self.prog.get('1.0',END+'-1c')
    self.prog.mark_set(INSERT,'1.0')
    self.prog.see(INSERT)
    self.prog.focus_set()
    self.notebook.selectpage(n.replace('_',marca))
    self.ponerBindingsProg()
    try: map(self.canvas.delete,self.canvas.find_all())
    except TclError: pass
    
  #se llama de nuevaPestanya
  def anyadirProgFuente(self,nom='<xxx>',ind=None):
    nomNuevo=nom.replace('_',marca)
    if ind==None: page=self.notebook.add(nomNuevo)
    else: page=self.notebook.insert(nomNuevo,before=ind)
    x=self.notebook.tab(nomNuevo)
    x.config(text=nom)
    x.bind('<FocusIn>', lambda e,s=self: s.prog.focus_set())
    #x.configure(takefocus=0)
    #fuente=Frame(page,borderwidth=0,relief=FLAT,highlightthickness=0)
    aux = Pmw.ScrolledText(page, borderframe=0, scrollmargin=0)
    prog = aux.component('text')
    prog.configure(font=tFuente,height=0,width=0,borderwidth=0,
                   foreground=conf['color_pordefecto']['foreground'],
                   background=conf['color_pordefecto']['background'],
                   insertbackground='red',insertwidth=3,
                   highlightthickness=0,#highlightcolor='red',
                   insertofftime=200, insertontime=500,wrap=NONE)
    if posix:
      for barra in 'horizscrollbar', 'vertscrollbar':
        aux.component(barra).configure(borderwidth=1,width=12,
                                       highlightthickness=0,
                                       activebackground='gray80',
                                       background='gray80', relief=SOLID)
    aux.pack(side=LEFT,fill=BOTH,expand=YES)
    #fuente.pack(side=TOP,fill=BOTH,expand=YES)
    #sys.__stderr__.write(`x.cget('width')`)
    #sys.__stderr__.write(`x['width']`)
    #sys.__stderr__.write(`x['height']`)
    return prog

  # FIN funciones que se llaman desde los menus
  # -----------------------------------------------------------------
    
  # -----------------------------------------------------------------
  # INI Teclas activas en pestaa intrprete

  def teclaReturnPython(self,event=None):
    global reading
    index=split(self.p.pestanya.index(INSERT),'.')
    texto=self.p.pestanya.get(index[0]+'.4',index[0]+'.end')
    if type(texto)!=type(u''):
      try: texto=unicode(texto,'utf8')
      except: pass
    if not reading:
      self.p.historia = self.p.historia[-100:-1]
      if not(len(self.p.historia)>0 and  self.p.historia[-1]==texto):
        if texto!='': self.p.historia.append(texto)
      self.p.historia.append('')
      self.p.posH=len(self.p.historia)-1
    if self.p.texto_incomp!='':
      t=self.p.texto_incomp+'\n'+texto
    else:
      t=texto
    if find(t,'modulepythong')!=-1 and find(t,'import')!=-1:
      t=''
    self.p.pestanya.insert(index[0]+'.end','\n')
    #self.p.pestanya.see(index[0]+'.0')
    self.p.pestanya.see(INSERT)
    if reading:
      self.raiz.quit() # Break out of recursive mainloop() in raw_input()
    else:
      #Quitamos keypressed
      #Para tener keypressed() en el intrprete habra que ejecutar
      #el intrprete en un thread (o desde keypressed llamar a mainloop)
      del globals()['__builtins__'].keypressed
      try: incompleto = self.p.int.runsource(t.encode(codigoChar))
      except:
        incompleto=0
        self.mostrarMensajeError(_('No se pudo ejecutar la lnea en el intrprete'))
      #restauramos keypressed
      globals()['__builtins__'].keypressed=ventana.keypressed
      if incompleto:
        self.p.texto_incomp=t
        self.p.int.write('... ')
      else:
        self.p.texto_incomp=''
        self.p.int.write('>>> ')
    #index=split(self.p.pestanya.index(INSERT),'.')
    #self.p.pestanya.see(index[0]+'.0')
    self.p.pestanya.see(INSERT)
    return "break"
      
  def teclaRetrocesoPython(self,event=None):
    index=split(self.p.pestanya.index(INSERT),'.')
    if int(index[1])<5: return "break"
     
  def teclaIzquierdaPython(self,event=None):
    global reading
    if reading: return "break"
    index=split(self.p.pestanya.index(INSERT),'.')
    if int(index[1])<5: return "break"

  def teclaDerechaPython(self,event=None):
    global reading
    if reading: return "break"
    index=split(self.p.pestanya.index(INSERT),'.')
    if int(index[1])<4: return "break"

  def teclaArribaPython(self,event=None):
    global reading
    if reading: return "break"
    index=split(self.p.pestanya.index(INSERT),'.')
    if len(self.p.historia)==0: return "break"
    if self.p.posH>0: self.p.posH = self.p.posH-1
    self.p.pestanya.delete(index[0]+'.4',index[0]+'.end')
    self.p.pestanya.insert(index[0]+'.4',self.p.historia[self.p.posH])
    return "break"

  def teclaAbajoPython(self,event=None):
    global reading
    if reading: return "break"
    index=split(self.p.pestanya.index(INSERT),'.')
    if len(self.p.historia)==0: return "break"
    if self.p.posH==len(self.p.historia)-1:  return "break"
    self.p.posH = self.p.posH+1
    self.p.pestanya.delete(index[0]+'.4',index[0]+'.end')
    self.p.pestanya.insert(index[0]+'.4',self.p.historia[self.p.posH])
    return "break"

  def teclaPython(self,event=None):
    index=split(self.prog.index(INSERT),'.')
    #print "XXX [%s][%s][%s]" % (event.type,event.keysym,event.char)
    if event.char=='' : return "break"
    self.presalir=0
    
  def teclaPythonIni(self,event=None):
    index=split(self.p.pestanya.index(INSERT),'.')
    self.prog.mark_set(INSERT, index[0]+'.'+str(4))
    self.prog.see(INSERT)
    return "break"
  
  # Resetea la pestaa del intrprete
  def teclaPythonReset(self,event=None):
    self.p.pestanya.delete('1.0',END+'-1c')
    self.p.output=OutputP()
    sys.stdout=sys.stderr=self.p.output
    (self.p.r,self.p.w)=os.pipe()
    self.p.inp=os.fdopen(self.p.w,"w",0)
    self.p.out=os.fdopen(self.p.r,"r",0)  
    self.p.stdin=InputP(self.p.out)
    sys.stdin=self.p.stdin
    ns=ponerBuildins()
    self.p.int = InteractiveInterpreter(ns)
    COPYRIGHT = 'Type "copyright", "credits" or "license" for more information.'
    sys.stderr=self.p.output
    self.p.int.write("Python %s on %s\n%s\n" %
                     (sys.version, sys.platform, COPYRIGHT))
    self.p.int.write(_('[Pulsa Control-d para reiniciar el intrprete]')+'\n>>> ')
    self.p.texto_incomp=''
    self.p.historia=['']
    self.p.posH=0
    index=split(self.p.pestanya.index(INSERT),'.')
    self.p.pestanya.see(index[0]+'.0')
    self.presalir=0
    self.p.pestanya.bind('<Return>', self.teclaReturnPython)
    self.p.pestanya.bind('<BackSpace>', self.teclaRetrocesoPython)
    self.p.pestanya.bind('<KeyPress>', self.teclaPython) 
    self.p.pestanya.bind('<Left>', self.teclaIzquierdaPython)
    self.p.pestanya.bind('<Right>', self.teclaDerechaPython)
    self.p.pestanya.bind('<Up>', self.teclaArribaPython)
    self.p.pestanya.bind('<Down>', self.teclaAbajoPython)
    self.p.pestanya.bind('<Control-d>', self.teclaPythonReset)
    self.p.pestanya.bind('<Control-D>', self.teclaPythonReset)
    self.p.pestanya.bind('<Control-a>', self.teclaPythonIni)
    self.p.pestanya.bind('<Control-A>', self.teclaPythonIni)
    self.p.pestanya.bind('<ButtonPress>', self.NoHacerNada)
    self.p.pestanya.bind('<ButtonRelease>', self.NoHacerNada)
    self.p.pestanya.bind('<Motion>', self.NoHacerNada)
    #self.p.pestanya.bind('<Alt-Left>', self.paginaPrevia)
    #self.p.pestanya.bind('<Alt-Right>', self.paginaSiguiente)
  # FIN Teclas activas en pestaa intrprete
  # -----------------------------------------------------------------
        
  #callback que evita poner el foco en ventana de salida de texto:
  #lo redirige a la ventana de programa
  def _focoProg(self,event=None): self.prog.focus_set()

  #callback que evita poner el foco en una pestaa:
  #lo redirige a la ventana de salida de texto
  def _focoProgS(self,event=None):
    self.progS.focus_set()
    return "break"

  #callback llegar pestaa
  def llegarPestanya(self,nombreMod):
    if self.ejecucion!='on': self.mostrarMensaje('')
    if nombreMod=='<python>':
      try:
        self.p = self.listaProg['<python>']
        sys.stdin=self.p.stdin
        sys.stdout=sys.stderr=self.p.output
        index=split(self.p.pestanya.index(INSERT),'.')
        self.p.pestanya.see(index[0]+'.0')
      except KeyError: pass
      self.python.configure(state=DISABLED)
      self.editar.configure(state=DISABLED)
      self.msg.pack_forget()
    else:
      #self.ponerBindingsProg()
      self.python.configure(state=NORMAL)
      self.editar.configure(state=NORMAL)
      #sys.stdin=self.aux_stdin
      #sys.stdout=self.aux_stdout
      #sys.stderr=self.aux_stderr
    try:
      aux=self.listaProg[nombreMod.replace(marca,'_')]
      #La linea anterior falla al crear la pestaa, por lo que las 4
      #lineas que siguen se hacen tambin en anyadirPestaa
      self.prog=aux.pestanya
      self.data=aux.data
      self.nombre=aux.nombre
      self.prog.focus_set()
    except KeyError: pass
    x=self.notebook.tab(nombreMod)
    x.configure(foreground = 'black', activeforeground = 'black') 
    ruta, nomFich = os.path.split(self.nombre)
    self.ponRuta(ruta)

  #callback dejar pestaa
  def dejarPestanya(self,nombreMod):
    x=self.notebook.tab(nombreMod)
    x.configure(foreground = 'gray60', activeforeground = 'gray60') 
    if nombreMod=='<python>': self.msg.pack(side=TOP,fill=X)
    
  #callbak modificar tamao ventana PythonG
  def tamPanel(self, l):
    if self.tamPaux==1:
      #self.raiz.configure(width=1000,height=1000)
      self.tamIzq,self.tamDer = l
      self.tamPaux=0
      return
    if l==[0,0]: return
    if l==[self.tamIzq,self.tamDer]: return
    if self.tamIzq==0 and self.tamDer==0:
      #print "ini",l
      self.tamIzq,self.tamDer = [(l[0]+l[1])-self.ancho-5,self.ancho+5]
      #self.tamFuenteD = self.tamDer
      self.paned.configurepane('derecha',max=self.ancho+5,min=self.ancho+5)
      self.paned.configurepane('derecha',max=100000,min=0)
    elif l[0]+l[1] > self.tamIzq+self.tamDer:
      #print "crece",l
      self.tamPaux=1
      v=self.tamDer*(l[0]+l[1])/(self.tamIzq+self.tamDer)
      self.paned.configurepane('derecha',max=v,min=v)
      self.paned.configurepane('derecha',max=100000,min=0)
      l[0]=(l[0]+l[1])-v
      l[1]=v
    elif l[0]+l[1] < self.tamIzq+self.tamDer:
      #print "decrece",l
      self.tamPaux=1
      v=self.tamDer*(l[0]+l[1])/(self.tamIzq+self.tamDer)
      self.paned.configurepane('derecha',max=v,min=v)
      self.paned.configurepane('derecha',max=100000,min=0)
      l[0]=(l[0]+l[1])-v
      l[1]=v
    else:
      pass
      #print "mueve",l
    self.tamIzq,self.tamDer = l

  def ponMenu(self,m):
    for e1,e2,menu in m:
      e1=e1.encode(codigoChar)
      if e2=='': self.menu.addmenu(e1,'')
      else:      self.menu.addmenu(e1,'',side=e2)
      for elem in menu:
        try:
          l,t,v=elem
          l=l.encode(codigoChar)
          self.menu.addmenuitem(e1,'checkbutton', label=l,variable=v)
        except:
          l,c=elem
          l=l.encode(codigoChar)
          if not activarCodDebug and c==self.depurar:
            continue
          if l!='': self.menu.addmenuitem(e1,'command', label=l, command=c)
          else:     self.menu.addmenuitem(e1,'separator')

  def imprimirViaWeb(self):
    global home
    from tokenize import generate_tokens, TokenError
    from keyword import iskeyword
    from token import tok_name

    dataP=self.prog.get('1.0',END+'-1c')
    # asegura que data sea unicode
    try: data=dataP.encode(codigoChar)
    except: data=dataP
    f=Mi_readline(data)
    ruta, nomFich2 = os.path.split(self.nombre)
    try: nomFich = nomFich2.encode(codigoChar)
    except: nomFich = nomFich2
    s=open(home+fichWeb,'w')
    cab="""<html>
    <head>
       <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
       <meta http-equiv="Pragma" content="no-cache">
       <meta http-equiv="expires" content="0">
    </head>
    <body style="font-family: monospace;" text="#000000" bgcolor="#FFFFFF">
    <font size="-1">
    """
#"
    s.write(cab)
    s.write('<h1>%s</h1>' % nomFich)

    sep='&nbsp;'*1
    #sep='-'

    fil,col=1,0
    try:
      for x in generate_tokens(f.readline):
        if x[0] in [5,6]: continue # INDENT , DEDENT

        c=x[1].replace('&','&amp;').replace('<','&lt;').replace('>','&gt;')
        fil2,col2=x[2]
 
        if fil2>fil: s.write('<br>\n');col=0
        if col2>col: s.write(sep*(col2-col))

        fil,col=x[3]
        col=x[2][1]+len(x[1])

        #sys.__stderr__.write(`(x[0],tok_name[x[0]],x[2],x[3])`+'\n')

        if iskeyword(c):
          s.write('<font color="#FF0000">%s</font>' % c)
        elif x[0]==3: # STRING
          s.write('<font color="brown">%s</font>' % c.replace('\n','<br>').replace(' ','&nbsp;'))
        elif x[0]==52: # COMMENT
          s.write('<font color="blue">%s</font>' % c.replace(' ','&nbsp;'))
        else:
          s.write(c)
    except TokenError: pass
    
    s.write('\n</font>\n</body>\n</html>\n')

    s.close()

    url='file://'+home+fichWeb
    webbrowser.open(url,new=1,autoraise=1)
    #os.remove(home+fichWeb)
    
  # Crea los widgets de la ventana de PythonG
  def ponObjetos(self):
    m=[(_('Fichero'), '', 
        ((_('Nuevo')+' (Ctrl-x Ctrl-n)', self.nuevoFichero),
         (_('Abrir')+' (Ctrl-x Ctrl-f)', self.abrirFichero),
         (_('Guardar')+' (Ctrl-x Ctrl-s)', lambda s=self: s.salvarFicheroComo(None,0)),
         (_('Guardar como...')+' (Ctrl-x Ctrl-w)', self.salvarFicheroComo),
         (_('Cerrar')+' (Ctrl-x k)', self.cerrarFichero),
         ('',''),
         (_('Guardar salida de texto...'), lambda s=self: s.salvarTextoComo(s.progS)),
         (_('Guardar salida grfica...'), self.salvarSalidaGraficaComo),
         ('',''),
         (_('Ver en navegador (permite imprimir)'), self.imprimirViaWeb),
         ('',''),
         (_('Salir')+' (Ctrl-x Ctrl-c)', self.salir))),
       (_('Editar'), '', 
        ((_('Deshacer')+' (Ctrl-z)', lambda s=self: s.raiz.event_generate('<Control-z>')),
         (_('Rehacer')+' (Ctrl-Alt-z)', lambda s=self: s.raiz.event_generate('<Control-Alt-z>')),
         ('',''),
         (_('Cortar')+' (Ctrl-x)', self.cortarSel),
         (_('Copiar')+' (Ctrl-c)', self.copiarSel),
         (_('Pegar')+' (Ctrl-v)', self.pegarSel),
         ('',''),
         (_('Buscar...')+' (Ctrl-s)', self.ponBuscar),
         (_('Reemplazar...')+' (Esc-%)', self.ponReemplazar),
         (_('Ir a lnea...')+' (Esc-g)', self.ponIrA))),
       (_('Opciones'), '', 
        ((_('Aumentar fuente')+' (Ctrl-plus)', self.teclaFuenteG),
         (_('Reducir fuente')+' (Ctrl-minus)', self.teclaFuenteP),
         ('', ''),
         (_('Pestaa siguiente')+' (Alt-Right)', lambda s=self: s.notebook.nextpage()),
         (_('Pestaa anterior')+' (Alt-Left)', lambda s=self: s.notebook.previouspage()),
         ('', ''),
         (_('Ocultar ventana de fuentes durante ejecucin'), 'c', self.ocultarFuentes),
         (_('Ocultar ventanas de salidas durante edicin'), 'c', self.ocultarSalidas),
         ('', ''),
         (_('Ocultar ventana de salida grfica'), 'c', self.ocultarSG),
         #)),
         ('', ''),
         (_('Cambiar idioma del interfaz'), self.cambiarIdioma))),
       ('Python', '', 
        ((_('Ejecutar/Abortar')+' (Ctrl-c Ctrl-c)', self.ejecutar),
         (_('Activar modo depuracin')+' (Ctrl-c Ctrl-d)', self.depurar),
         ('', ''),
         (_('Indentar regin')+' (Ctrl->)', self.indentarSel),
         (_('Desindentar regin')+' (Ctrl-<)', self.dedentarSel),
         ('', ''),
         (_('Comentar regin'), self.comentarSel),
         (_('Descomentar regin'), self.descomentarSel))),
       (_('Ayuda'), 'right',
        ((_('Funciones predefinidas de PythonG...'), lambda: webbrowser.open(url_docFuncPG,new=1,autoraise=1)),
         (_('Web de PythonG...'), lambda: webbrowser.open(url_webPythonG,new=1,autoraise=1)),
         ('', ''),
         (_('Documentacin de Python (web en ingls)...'), lambda: webbrowser.open(url_docPython,new=1,autoraise=1)),
         ('', ''),
         (_('Acerca de PythonG...'), self.acercaDe)))]
    barra = Frame(self.raiz,borderwidth=1,relief=RAISED)
    self.menu=Pmw.MenuBar(barra)
    self.ponMenu(m)
    self.menu.pack(side=TOP,expand=NO,fill=X)
    self.python=self.menu.component('Python-button')
    self.editar=self.menu.component(_('Editar')+'-button')
    barra.pack(side=TOP,expand=NO,fill=X)
    
    self.paned=Pmw.PanedWidget(self.raiz,orient=HORIZONTAL,command=self.tamPanel)
    self.paned.add('derecha',size=anchoOrig[grSizeDefecto]+10)
    self.paned.insert('izquierda',size=self.tamIni[0]-anchoOrig[grSizeDefecto]-10)
    #-------------------------------------------------------------------------

    #-----
    self.notebook=Pmw.NoteBook(self.paned.pane('izquierda'),borderwidth=2,
                               pagemargin=4,
                               raisecommand=self.llegarPestanya,
                               lowercommand=self.dejarPestanya)
    self.notebook.configure(hull_background=self.raiz.cget('background'),hull_height=1)
                           
    xx=self.notebook.component('hull')
    self.notebook.pack(fill=BOTH,expand=YES)
    #-----
    self.msg=Frame(self.paned.pane('izquierda'),borderwidth=1,relief=RAISED)
    Label(self.msg, text=_('Ruta: '),anchor=E,
          relief=FLAT, borderwidth=2).pack(side=LEFT,expand=NO)
    Label(self.msg,textvariable=self.nombreRuta,anchor=W,width=20,
          relief=FLAT, borderwidth=2,foreground='darkblue').pack(side=LEFT,fill=X,expand=YES)
    Label(self.msg,textvariable=self.linea,anchor=E,width=4,
          relief=FLAT, borderwidth=2,foreground='darkblue').pack(side=RIGHT,expand=NO)
    Label(self.msg, text=_('Lnea: '),anchor=E,
          relief=FLAT, borderwidth=2).pack(side=RIGHT,expand=NO)
    self.msg.pack(side=TOP,fill=X)
    #-----
    self.msg2=Frame(self.paned.pane('izquierda'),borderwidth=1,relief=RAISED)
    self.msg2.pack(side=BOTTOM,fill=X)
    
    #-------------------------------------------------------------------------

    salida = Frame(self.paned.pane('derecha'),borderwidth=0)
    self.workspace = Frame(salida,borderwidth=1,relief=SOLID)
    #self.scanvas = Pmw.ScrolledCanvas(self.workspace,borderframe=0)
                                #hull_width=200,hull_height=200,usehullsize=1)
    self.canvas=Canvas(self.workspace)#self.scanvas.component('canvas')
    self.canvas.configure(width=self.ancho,height=self.alto,
                          highlightthickness=0, bg='white',borderwidth=0,
                          relief=SOLID)
    #self.scanvas.pack(expand=NO)
    self.canvas.pack(expand=NO)
    self.workspace.pack(side=TOP,expand=NO,pady=4)
    if conf['salida_grafica']=='off':
      self.workspace.pack_forget()
    
    self.window_size(self.ancho,self.alto)
    self.window_coordinates(self.xinf,self.yinf,self.xsup,self.ysup)
    self.fTextoS = Frame(salida,borderwidth=2,relief=SUNKEN)
    aux = Pmw.ScrolledText(self.fTextoS, borderframe=0, scrollmargin=1)
    self.progS = aux.component('text')
    self.progS.configure(font=tFuente, height=10, width=1, borderwidth=0,
                         foreground=conf['color_salida']['foreground'],
                         background=conf['color_salida']['background'],
                         insertbackground='red',insertwidth=3,
                         insertofftime=200, insertontime=500,
                         highlightthickness=0,#highlightcolor='red',
                         state=DISABLED, wrap="char")
    self.progS.bind('<FocusIn>', self._focoProg)
    self.progS.configure(state=NORMAL)
    for barra in 'horizscrollbar', 'vertscrollbar':
      aux.component(barra).configure(borderwidth=1,width=12,
                                     highlightthickness=0,
                                     activebackground='gray80',
                                     background='gray80', relief=SOLID)
    aux.pack(side=BOTTOM,fill=BOTH,expand=YES)
    f2=Frame(salida,borderwidth=0,relief=FLAT)
    self.botonSG=Button(f2, text='G', command=self.mostrarOcultarSG)
    self.botonSG.pack(side=RIGHT)
    Label(f2, text=_("Entrada de teclado/Salida de texto:"),
          anchor=W).pack(side=LEFT,fill=X)
    self.fTextoS.pack(side=BOTTOM,fill=BOTH,expand=YES)
    f2.pack(side=BOTTOM,fill=X)
    salida.pack(side=TOP,fill=BOTH,expand=YES)
    self.canvas.bind('<Motion>',self.eventoRatonMovido)
    self.canvas.bind('<B1-Motion>',self.eventoRatonMovidoB1)
    self.canvas.bind('<B2-Motion>',self.eventoRatonMovidoB2)
    self.canvas.bind('<B3-Motion>',self.eventoRatonMovidoB3)
    self.canvas.bind('<Leave>',self.eventoRatonFuera)
    self.canvas.bind('<ButtonRelease>',self.eventoBotonSoltado)
    self.canvas.bind('<Button-1>',self.eventoBoton1Pulsado)
    self.canvas.bind('<Button-2>',self.eventoBoton2Pulsado)
    self.canvas.bind('<Button-3>',self.eventoBoton3Pulsado)
    self.progS.bind('<KeyPress>',self.eventoTeclaPulsada)
    self.progS.bind('<KeyRelease>', self.eventoTeclaSoltada)
    #self.progS.bind('<ButtonPress>',self.NoHacerNada)
    self.progS.bind('<ButtonPress>', self.focoProgS)
    self.progS.bind('<ButtonRelease>',self.NoHacerNada)
    self.progS.bind('<Motion>',self.NoHacerNada)
    #-------------------------------------------------------------------------
    self.paned.pack(side=LEFT,fill=BOTH,expand=YES)

  def cambiarIdioma(self):
    if not activarIdioma: return
    aux=Toplevel(self.raiz)
    aux.title('Seleccione idioma')
    idiomaOrig=conf['idioma']
    conf['idioma']=None
    idioma=''
    def auxIdioma(eti):
      global idioma
      if eti=='Por defecto/System default':
          conf['idioma']='entorno'
      elif eti=='Espaol':
          conf['idioma']='es_ES'
      elif eti=='English':
          conf['idioma']='en_US'
      elif eti=='Catal':
          conf['idioma']='ca_ES'
      radio.quit()
      
    radio = Pmw.RadioSelect(aux,
            command = auxIdioma,
            labelpos = 'n',
            label_text = "Elige el idioma/Choose language/Tria l'idioma:",
            orient='horizontal')
    radio.pack(padx = 20, pady = 20)
    for f in ('Espaol','English','Catal','Por defecto/System default'): radio.add(f)

    aux.transient(self.raiz)
    aux.grab_set()
    radio.focus_set()
    try:
      aux.mainloop()#wait_window()
    except:
      pass
    if conf['idioma']==None:
      conf['idioma']=idiomaOrig
    aux.grab_release()
    self.prog.focus_set()
    aux.destroy()
    tkMessageBox.showerror(_('ATENCIN'),
                           _('El cambio de idioma se efectuar cuando reinicie PythonG.'))
    self.prog.focus_set()
# FIN Clase principal de PythonG ----------------------------------
# -----------------------------------------------------------------

# Funcin que muestra como lanzar PythonG
def _utilizacion():
  print _("Utilizacin:\n  python pythong.py [fichero1.py fichero2.py ...]\n")

# -----------------------------------------------------------------
# INI Programa principal ------------------------------------------
try:
  from getopt import getopt, GetoptError
  opts, args = getopt(sys.argv[1:], "h", ["help"])
except GetoptError:
  _utilizacion()
  sys.exit(2)
for o, a in opts:
  if o in ("-h", "--help"):
    _utilizacion()
    sys.exit()

Ventana(args) # Lanza la ventana con los ficheros indicados
# FIN Programa principal ------------------------------------------
# -----------------------------------------------------------------
